-- MySQL dump 10.13  Distrib 8.0.44, for Win64 (x86_64)
--
-- Host: localhost    Database: atape_db
-- ------------------------------------------------------
-- Server version	8.0.30

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Bank',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `currency` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'TZS',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_organization_id_foreign` (`organization_id`),
  CONSTRAINT `accounts_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,5,'01J856987412','Bank',1000500000.00,'TZS','2025-12-26 08:10:16','2025-12-26 08:12:45',NULL);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activity_plans`
--

DROP TABLE IF EXISTS `activity_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_plans` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `year` int NOT NULL,
  `objective` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `activity_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `venue` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `budget_est` decimal(15,2) NOT NULL DEFAULT '0.00',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_plans_organization_id_foreign` (`organization_id`),
  CONSTRAINT `activity_plans_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activity_plans`
--

LOCK TABLES `activity_plans` WRITE;
/*!40000 ALTER TABLE `activity_plans` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_plans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_logs`
--

DROP TABLE IF EXISTS `audit_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `record_id` bigint unsigned NOT NULL,
  `old_values` json DEFAULT NULL,
  `new_values` json DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_logs_user_id_foreign` (`user_id`),
  CONSTRAINT `audit_logs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_logs`
--

LOCK TABLES `audit_logs` WRITE;
/*!40000 ALTER TABLE `audit_logs` DISABLE KEYS */;
INSERT INTO `audit_logs` VALUES (1,NULL,'Create','organizations',1,NULL,'{\"id\": 1, \"code\": \"ATAPE-TZ\", \"name\": \"ATAPE Tanzania\", \"level_id\": 1, \"location\": \"Dar es Salaam\", \"created_at\": \"2025-12-22 10:08:24\", \"updated_at\": \"2025-12-22 10:08:24\"}','127.0.0.1','2025-12-22 07:08:24','2025-12-22 07:08:24'),(2,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-22 07:08:52','2025-12-22 07:08:52'),(3,1,'Create','organizations',2,NULL,'{\"id\": 2, \"code\": \"EA1\", \"name\": \"Eastern Union\", \"level_id\": \"2\", \"location\": null, \"parent_id\": \"1\", \"created_at\": \"2025-12-22 10:09:42\", \"updated_at\": \"2025-12-22 10:09:42\"}','127.0.0.1','2025-12-22 07:09:42','2025-12-22 07:09:42'),(4,1,'Create','organizations',3,NULL,'{\"id\": 3, \"code\": \"SA1\", \"name\": \"Southern Union\", \"level_id\": \"2\", \"location\": null, \"parent_id\": \"1\", \"created_at\": \"2025-12-22 10:10:07\", \"updated_at\": \"2025-12-22 10:10:07\"}','127.0.0.1','2025-12-22 07:10:07','2025-12-22 07:10:07'),(5,1,'Create','organizations',4,NULL,'{\"id\": 4, \"code\": \"SA1-1\", \"name\": \"Central Tanzania Conference\", \"level_id\": \"3\", \"location\": null, \"parent_id\": \"3\", \"created_at\": \"2025-12-22 10:10:56\", \"updated_at\": \"2025-12-22 10:10:56\"}','127.0.0.1','2025-12-22 07:10:56','2025-12-22 07:10:56'),(6,1,'Create','organizations',5,NULL,'{\"id\": 5, \"code\": \"SA1-1-1\", \"name\": \"Zanzibar Zone\", \"level_id\": \"4\", \"location\": null, \"parent_id\": \"4\", \"created_at\": \"2025-12-22 10:17:17\", \"updated_at\": \"2025-12-22 10:17:17\"}','127.0.0.1','2025-12-22 07:17:17','2025-12-22 07:17:17'),(7,1,'Create','organizations',6,NULL,'{\"id\": 6, \"code\": \"SA1-11\", \"name\": \"Zanzibar SDA\", \"level_id\": \"5\", \"location\": null, \"parent_id\": \"5\", \"created_at\": \"2025-12-22 10:17:55\", \"updated_at\": \"2025-12-22 10:17:55\"}','127.0.0.1','2025-12-22 07:17:55','2025-12-22 07:17:55'),(8,1,'Create','members',1,NULL,'{\"id\": 1, \"dob\": \"1981-04-20 00:00:00\", \"email\": \"hedulux@mailinator.com\", \"phone\": \"+1 (236) 247-9979\", \"gender\": \"Female\", \"status\": \"Active\", \"category\": \"Professional\", \"last_name\": \"Gonzales\", \"created_at\": \"2025-12-22 10:19:18\", \"first_name\": \"Zorita\", \"profession\": \"Magnam error mollit\", \"updated_at\": \"2025-12-22 10:19:18\", \"marital_status\": \"Aut suscipit omnis q\", \"organization_id\": \"6\"}','127.0.0.1','2025-12-22 07:19:18','2025-12-22 07:19:18'),(9,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-22 07:21:27','2025-12-22 07:21:27'),(10,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 05:42:28','2025-12-26 05:42:28'),(11,NULL,'Logout','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 06:37:31','2025-12-26 06:37:31'),(12,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 06:38:23','2025-12-26 06:38:23'),(13,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 06:44:10','2025-12-26 06:44:10'),(14,NULL,'Logout','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 06:44:50','2025-12-26 06:44:50'),(15,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 06:48:28','2025-12-26 06:48:28'),(16,NULL,'Logout','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 06:50:28','2025-12-26 06:50:28'),(17,NULL,'Logout','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 06:50:48','2025-12-26 06:50:48'),(18,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 07:28:25','2025-12-26 07:28:25'),(19,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 07:56:22','2025-12-26 07:56:22'),(20,1,'Create','budgets',1,NULL,'{\"id\": 1, \"created_at\": \"2025-12-26 11:02:16\", \"updated_at\": \"2025-12-26 11:02:16\", \"fiscal_year\": \"2026\", \"organization_id\": \"5\"}','127.0.0.1','2025-12-26 08:02:16','2025-12-26 08:02:16'),(21,1,'Create','budget_items',1,NULL,'{\"id\": 1, \"amount\": \"500000\", \"budget_id\": 1, \"created_at\": \"2025-12-26 11:05:33\", \"updated_at\": \"2025-12-26 11:05:33\", \"category_id\": \"12\", \"description\": null}','127.0.0.1','2025-12-26 08:05:33','2025-12-26 08:05:33'),(22,1,'Update','budgets',1,'{\"id\": 1, \"status\": \"Draft\", \"created_at\": \"2025-12-26T11:02:16.000000Z\", \"updated_at\": \"2025-12-26T11:02:16.000000Z\", \"fiscal_year\": 2026, \"total_income\": \"0.00\", \"total_expense\": \"0.00\", \"organization_id\": 5}','{\"updated_at\": \"2025-12-26 11:05:33\", \"total_expense\": \"500000.00\"}','127.0.0.1','2025-12-26 08:05:33','2025-12-26 08:05:33'),(23,1,'Create','budget_items',2,NULL,'{\"id\": 2, \"amount\": \"10000000\", \"budget_id\": 1, \"created_at\": \"2025-12-26 11:06:32\", \"updated_at\": \"2025-12-26 11:06:32\", \"category_id\": \"7\", \"description\": null}','127.0.0.1','2025-12-26 08:06:32','2025-12-26 08:06:32'),(24,1,'Update','budgets',1,'{\"id\": 1, \"status\": \"Draft\", \"created_at\": \"2025-12-26T11:02:16.000000Z\", \"updated_at\": \"2025-12-26T11:05:33.000000Z\", \"fiscal_year\": 2026, \"total_income\": \"0.00\", \"total_expense\": \"500000.00\", \"organization_id\": 5}','{\"updated_at\": \"2025-12-26 11:06:32\", \"total_expense\": \"10500000.00\"}','127.0.0.1','2025-12-26 08:06:32','2025-12-26 08:06:32'),(25,1,'Create','accounts',1,NULL,'{\"id\": 1, \"name\": \"01J856987412\", \"type\": \"Bank\", \"balance\": 0, \"currency\": \"TZS\", \"created_at\": \"2025-12-26 11:10:16\", \"updated_at\": \"2025-12-26 11:10:16\", \"organization_id\": \"5\"}','127.0.0.1','2025-12-26 08:10:16','2025-12-26 08:10:16'),(26,1,'Create','transactions',1,NULL,'{\"id\": 1, \"date\": \"2025-12-26 00:00:00\", \"type\": \"Credit\", \"amount\": \"500000\", \"status\": \"Approved\", \"reference\": \"23423432\", \"account_id\": \"1\", \"created_at\": \"2025-12-26 11:11:19\", \"updated_at\": \"2025-12-26 11:11:19\", \"category_id\": \"2\", \"description\": \"Contribution from Zorita Gonzales: basi tu\", \"recorded_by\": 1, \"organization_id\": 5}','127.0.0.1','2025-12-26 08:11:19','2025-12-26 08:11:19'),(27,1,'Update','accounts',1,'{\"id\": 1, \"name\": \"01J856987412\", \"type\": \"Bank\", \"balance\": \"0.00\", \"currency\": \"TZS\", \"created_at\": \"2025-12-26T11:10:16.000000Z\", \"updated_at\": \"2025-12-26T11:10:16.000000Z\", \"organization_id\": 5}','{\"balance\": 500000}','127.0.0.1','2025-12-26 08:11:19','2025-12-26 08:11:19'),(28,1,'Create','contributions',1,NULL,'{\"id\": 1, \"date\": \"2025-12-26 00:00:00\", \"amount\": \"500000\", \"purpose\": \"basi tu\", \"member_id\": \"1\", \"pledge_id\": null, \"created_at\": \"2025-12-26 11:11:19\", \"updated_at\": \"2025-12-26 11:11:19\", \"transaction_id\": 1}','127.0.0.1','2025-12-26 08:11:19','2025-12-26 08:11:19'),(29,1,'Update','budgets',1,'{\"id\": 1, \"status\": \"Draft\", \"created_at\": \"2025-12-26T11:02:16.000000Z\", \"updated_at\": \"2025-12-26T11:06:32.000000Z\", \"fiscal_year\": 2026, \"total_income\": \"0.00\", \"total_expense\": \"10500000.00\", \"organization_id\": 5}','{\"status\": \"Approved\", \"updated_at\": \"2025-12-26 11:12:00\"}','127.0.0.1','2025-12-26 08:12:00','2025-12-26 08:12:00'),(30,1,'Create','transactions',2,NULL,'{\"id\": 2, \"date\": \"2025-12-26 00:00:00\", \"type\": \"Credit\", \"amount\": \"1000000000\", \"status\": \"Approved\", \"reference\": null, \"account_id\": \"1\", \"created_at\": \"2025-12-26 11:12:45\", \"updated_at\": \"2025-12-26 11:12:45\", \"category_id\": \"6\", \"description\": null, \"recorded_by\": 1, \"organization_id\": 5}','127.0.0.1','2025-12-26 08:12:45','2025-12-26 08:12:45'),(31,1,'Update','accounts',1,'{\"id\": 1, \"name\": \"01J856987412\", \"type\": \"Bank\", \"balance\": \"500000.00\", \"currency\": \"TZS\", \"created_at\": \"2025-12-26T11:10:16.000000Z\", \"updated_at\": \"2025-12-26T11:11:19.000000Z\", \"organization_id\": 5}','{\"balance\": 1000500000}','127.0.0.1','2025-12-26 08:12:45','2025-12-26 08:12:45'),(32,1,'Create','budgets',2,NULL,'{\"id\": 2, \"created_at\": \"2025-12-26 11:16:13\", \"updated_at\": \"2025-12-26 11:16:13\", \"fiscal_year\": \"2025\", \"organization_id\": \"6\"}','127.0.0.1','2025-12-26 08:16:13','2025-12-26 08:16:13'),(33,1,'Create','budget_items',3,NULL,'{\"id\": 3, \"amount\": \"1000000\", \"budget_id\": 2, \"created_at\": \"2025-12-26 11:16:32\", \"updated_at\": \"2025-12-26 11:16:32\", \"category_id\": \"5\", \"description\": null}','127.0.0.1','2025-12-26 08:16:32','2025-12-26 08:16:32'),(34,1,'Update','budgets',2,'{\"id\": 2, \"status\": \"Draft\", \"created_at\": \"2025-12-26T11:16:13.000000Z\", \"updated_at\": \"2025-12-26T11:16:13.000000Z\", \"fiscal_year\": 2025, \"total_income\": \"0.00\", \"total_expense\": \"0.00\", \"organization_id\": 6}','{\"updated_at\": \"2025-12-26 11:16:32\", \"total_income\": \"1000000.00\"}','127.0.0.1','2025-12-26 08:16:32','2025-12-26 08:16:32'),(35,1,'Create','budget_items',4,NULL,'{\"id\": 4, \"amount\": \"500000\", \"budget_id\": 2, \"created_at\": \"2025-12-26 11:16:48\", \"updated_at\": \"2025-12-26 11:16:48\", \"category_id\": \"1\", \"description\": null}','127.0.0.1','2025-12-26 08:16:48','2025-12-26 08:16:48'),(36,1,'Update','budgets',2,'{\"id\": 2, \"status\": \"Draft\", \"created_at\": \"2025-12-26T11:16:13.000000Z\", \"updated_at\": \"2025-12-26T11:16:32.000000Z\", \"fiscal_year\": 2025, \"total_income\": \"1000000.00\", \"total_expense\": \"0.00\", \"organization_id\": 6}','{\"updated_at\": \"2025-12-26 11:16:48\", \"total_income\": \"1500000.00\"}','127.0.0.1','2025-12-26 08:16:48','2025-12-26 08:16:48'),(37,1,'Create','budget_items',5,NULL,'{\"id\": 5, \"amount\": \"12000000\", \"budget_id\": 2, \"created_at\": \"2025-12-26 11:17:04\", \"updated_at\": \"2025-12-26 11:17:04\", \"category_id\": \"6\", \"description\": null}','127.0.0.1','2025-12-26 08:17:04','2025-12-26 08:17:04'),(38,1,'Update','budgets',2,'{\"id\": 2, \"status\": \"Draft\", \"created_at\": \"2025-12-26T11:16:13.000000Z\", \"updated_at\": \"2025-12-26T11:16:48.000000Z\", \"fiscal_year\": 2025, \"total_income\": \"1500000.00\", \"total_expense\": \"0.00\", \"organization_id\": 6}','{\"updated_at\": \"2025-12-26 11:17:04\", \"total_income\": \"13500000.00\"}','127.0.0.1','2025-12-26 08:17:04','2025-12-26 08:17:04'),(39,1,'Create','budgets',3,NULL,'{\"id\": 3, \"created_at\": \"2025-12-26 11:22:18\", \"updated_at\": \"2025-12-26 11:22:18\", \"fiscal_year\": \"2026\", \"organization_id\": \"1\"}','127.0.0.1','2025-12-26 08:22:18','2025-12-26 08:22:18'),(40,1,'Create','budget_items',6,NULL,'{\"id\": 6, \"amount\": \"1000000\", \"budget_id\": 3, \"created_at\": \"2025-12-26 11:24:15\", \"updated_at\": \"2025-12-26 11:24:15\", \"category_id\": \"2\", \"description\": \"Annual donations\"}','127.0.0.1','2025-12-26 08:24:15','2025-12-26 08:24:15'),(41,1,'Update','budgets',3,'{\"id\": 3, \"status\": \"Draft\", \"created_at\": \"2025-12-26T11:22:18.000000Z\", \"creator_id\": null, \"updated_at\": \"2025-12-26T11:22:18.000000Z\", \"approver_id\": null, \"fiscal_year\": 2026, \"total_income\": \"0.00\", \"total_expense\": \"0.00\", \"organization_id\": 1, \"rejection_reason\": null}','{\"updated_at\": \"2025-12-26 11:24:15\", \"total_income\": \"1000000.00\"}','127.0.0.1','2025-12-26 08:24:15','2025-12-26 08:24:15'),(42,NULL,'Logout','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 08:29:56','2025-12-26 08:29:56'),(43,NULL,'Login Failed','users',3,NULL,'{\"email\": \"bidix@mailinator.com\", \"reason\": \"Invalid password\"}','127.0.0.1','2025-12-26 08:30:33','2025-12-26 08:30:33'),(44,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 08:30:51','2025-12-26 08:30:51'),(45,NULL,'Logout','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 08:33:42','2025-12-26 08:33:42'),(46,4,'Login','users',4,NULL,'{\"email\": \"checker@atape.or.tz\"}','127.0.0.1','2025-12-26 08:34:03','2025-12-26 08:34:03'),(47,NULL,'Logout','users',4,NULL,'{\"email\": \"checker@atape.or.tz\"}','127.0.0.1','2025-12-26 08:36:28','2025-12-26 08:36:28'),(48,2,'Login','users',2,NULL,'{\"email\": \"jane@atape.or.tz\"}','127.0.0.1','2025-12-26 08:36:53','2025-12-26 08:36:53'),(49,NULL,'Logout','users',2,NULL,'{\"email\": \"jane@atape.or.tz\"}','127.0.0.1','2025-12-26 08:39:31','2025-12-26 08:39:31'),(50,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 08:40:17','2025-12-26 08:40:17'),(51,1,'Update','budgets',1,'{\"id\": 1, \"status\": \"Approved\", \"created_at\": \"2025-12-26T11:02:16.000000Z\", \"creator_id\": null, \"updated_at\": \"2025-12-26T11:12:00.000000Z\", \"approver_id\": null, \"fiscal_year\": 2026, \"total_income\": \"0.00\", \"total_expense\": \"10500000.00\", \"organization_id\": 5, \"rejection_reason\": null}','{\"status\": \"Amendment Pending\", \"updated_at\": \"2025-12-26 11:40:57\"}','127.0.0.1','2025-12-26 08:40:57','2025-12-26 08:40:57'),(52,1,'Create','budgets',4,NULL,'{\"id\": 4, \"created_at\": \"2025-12-26 11:41:15\", \"updated_at\": \"2025-12-26 11:41:15\", \"fiscal_year\": \"2026\", \"organization_id\": \"3\"}','127.0.0.1','2025-12-26 08:41:15','2025-12-26 08:41:15'),(53,1,'Create','budget_items',7,NULL,'{\"id\": 7, \"amount\": \"5000000\", \"budget_id\": 4, \"created_at\": \"2025-12-26 11:42:36\", \"updated_at\": \"2025-12-26 11:42:36\", \"category_id\": \"1\", \"description\": null}','127.0.0.1','2025-12-26 08:42:36','2025-12-26 08:42:36'),(54,1,'Update','budgets',4,'{\"id\": 4, \"status\": \"Draft\", \"created_at\": \"2025-12-26T11:41:15.000000Z\", \"creator_id\": null, \"updated_at\": \"2025-12-26T11:41:15.000000Z\", \"approver_id\": null, \"fiscal_year\": 2026, \"total_income\": \"0.00\", \"total_expense\": \"0.00\", \"organization_id\": 3, \"rejection_reason\": null}','{\"updated_at\": \"2025-12-26 11:42:36\", \"total_income\": \"5000000.00\"}','127.0.0.1','2025-12-26 08:42:36','2025-12-26 08:42:36'),(55,NULL,'Logout','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 08:49:07','2025-12-26 08:49:07'),(56,4,'Login','users',4,NULL,'{\"email\": \"checker@atape.or.tz\"}','127.0.0.1','2025-12-26 08:49:28','2025-12-26 08:49:28'),(57,NULL,'Logout','users',4,NULL,'{\"email\": \"checker@atape.or.tz\"}','127.0.0.1','2025-12-26 08:50:56','2025-12-26 08:50:56'),(58,1,'Login','users',1,NULL,'{\"email\": \"admin@atape.or.tz\"}','127.0.0.1','2025-12-26 08:51:41','2025-12-26 08:51:41'),(59,1,'Delete','members',1,'{\"id\": 1, \"dob\": \"1981-04-20\", \"email\": \"hedulux@mailinator.com\", \"phone\": \"+1 (236) 247-9979\", \"gender\": \"Female\", \"status\": \"Active\", \"user_id\": null, \"category\": \"Professional\", \"last_name\": \"Gonzales\", \"created_at\": \"2025-12-22 10:19:18\", \"deleted_at\": \"2025-12-26 12:11:48\", \"first_name\": \"Zorita\", \"profession\": \"Magnam error mollit\", \"updated_at\": \"2025-12-26 12:11:48\", \"marital_status\": \"Aut suscipit omnis q\", \"organization_id\": 6}',NULL,'127.0.0.1','2025-12-26 09:11:48','2025-12-26 09:11:48');
/*!40000 ALTER TABLE `audit_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `budget_items`
--

DROP TABLE IF EXISTS `budget_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budget_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `budget_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `budget_items_budget_id_foreign` (`budget_id`),
  KEY `budget_items_category_id_foreign` (`category_id`),
  CONSTRAINT `budget_items_budget_id_foreign` FOREIGN KEY (`budget_id`) REFERENCES `budgets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `budget_items_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `transaction_categories` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `budget_items`
--

LOCK TABLES `budget_items` WRITE;
/*!40000 ALTER TABLE `budget_items` DISABLE KEYS */;
INSERT INTO `budget_items` VALUES (1,1,12,500000.00,NULL,'2025-12-26 08:05:33','2025-12-26 08:05:33',NULL),(2,1,7,10000000.00,NULL,'2025-12-26 08:06:32','2025-12-26 08:06:32',NULL),(3,2,5,1000000.00,NULL,'2025-12-26 08:16:32','2025-12-26 08:16:32',NULL),(4,2,1,500000.00,NULL,'2025-12-26 08:16:48','2025-12-26 08:16:48',NULL),(5,2,6,12000000.00,NULL,'2025-12-26 08:17:04','2025-12-26 08:17:04',NULL),(6,3,2,1000000.00,'Annual donations','2025-12-26 08:24:15','2025-12-26 08:24:15',NULL),(7,4,1,5000000.00,NULL,'2025-12-26 08:42:36','2025-12-26 08:42:36',NULL);
/*!40000 ALTER TABLE `budget_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `budgets`
--

DROP TABLE IF EXISTS `budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `fiscal_year` int NOT NULL,
  `total_income` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_expense` decimal(15,2) NOT NULL DEFAULT '0.00',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Draft',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `creator_id` bigint unsigned DEFAULT NULL,
  `approver_id` bigint unsigned DEFAULT NULL,
  `rejection_reason` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `budgets_organization_id_foreign` (`organization_id`),
  KEY `budgets_creator_id_foreign` (`creator_id`),
  KEY `budgets_approver_id_foreign` (`approver_id`),
  CONSTRAINT `budgets_approver_id_foreign` FOREIGN KEY (`approver_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `budgets_creator_id_foreign` FOREIGN KEY (`creator_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `budgets_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `budgets`
--

LOCK TABLES `budgets` WRITE;
/*!40000 ALTER TABLE `budgets` DISABLE KEYS */;
INSERT INTO `budgets` VALUES (1,5,2026,0.00,10500000.00,'Amendment Pending','2025-12-26 08:02:16','2025-12-26 08:40:57',NULL,NULL,NULL,NULL),(2,6,2025,13500000.00,0.00,'Draft','2025-12-26 08:16:13','2025-12-26 08:17:04',NULL,NULL,NULL,NULL),(3,1,2026,1000000.00,0.00,'Draft','2025-12-26 08:22:18','2025-12-26 08:24:15',NULL,NULL,NULL,NULL),(4,3,2026,5000000.00,0.00,'Draft','2025-12-26 08:41:15','2025-12-26 08:42:36',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `budgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
INSERT INTO `cache` VALUES ('atape-manager-cache-spatie.permission.cache','a:3:{s:5:\"alias\";a:4:{s:1:\"a\";s:2:\"id\";s:1:\"b\";s:4:\"name\";s:1:\"c\";s:10:\"guard_name\";s:1:\"r\";s:5:\"roles\";}s:11:\"permissions\";a:47:{i:0;a:4:{s:1:\"a\";i:1;s:1:\"b\";s:10:\"users.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:1;a:4:{s:1:\"a\";i:2;s:1:\"b\";s:12:\"users.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:2;a:4:{s:1:\"a\";i:3;s:1:\"b\";s:10:\"users.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:3;a:4:{s:1:\"a\";i:4;s:1:\"b\";s:12:\"users.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:4;a:4:{s:1:\"a\";i:5;s:1:\"b\";s:12:\"members.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:8:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;}}i:5;a:4:{s:1:\"a\";i:6;s:1:\"b\";s:14:\"members.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:8:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;}}i:6;a:4:{s:1:\"a\";i:7;s:1:\"b\";s:12:\"members.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:8:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;}}i:7;a:4:{s:1:\"a\";i:8;s:1:\"b\";s:14:\"members.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:8;a:4:{s:1:\"a\";i:9;s:1:\"b\";s:14:\"members.export\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:4:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:6;}}i:9;a:4:{s:1:\"a\";i:10;s:1:\"b\";s:12:\"finance.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:4:{i:0;i:1;i:1;i:3;i:2;i:4;i:3;i:10;}}i:10;a:4:{s:1:\"a\";i:11;s:1:\"b\";s:14:\"finance.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:10;}}i:11;a:4:{s:1:\"a\";i:12;s:1:\"b\";s:12:\"finance.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:10;}}i:12;a:4:{s:1:\"a\";i:13;s:1:\"b\";s:14:\"finance.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:10;}}i:13;a:4:{s:1:\"a\";i:14;s:1:\"b\";s:15:\"finance.approve\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:10;}}i:14;a:4:{s:1:\"a\";i:15;s:1:\"b\";s:12:\"reports.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:7:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:6;i:5;i:7;i:6;i:8;}}i:15;a:4:{s:1:\"a\";i:16;s:1:\"b\";s:14:\"reports.export\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:4:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:6;}}i:16;a:4:{s:1:\"a\";i:17;s:1:\"b\";s:15:\"settings.manage\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:17;a:4:{s:1:\"a\";i:18;s:1:\"b\";s:14:\"dashboard.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:7:{i:0;i:1;i:1;i:2;i:2;i:5;i:3;i:6;i:4;i:7;i:5;i:8;i:6;i:9;}}i:18;a:4:{s:1:\"a\";i:19;s:1:\"b\";s:18:\"organizations.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:6:{i:0;i:1;i:1;i:2;i:2;i:5;i:3;i:6;i:4;i:7;i:5;i:8;}}i:19;a:4:{s:1:\"a\";i:20;s:1:\"b\";s:20:\"organizations.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:2;}}i:20;a:4:{s:1:\"a\";i:21;s:1:\"b\";s:18:\"organizations.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:3:{i:0;i:1;i:1;i:2;i:2;i:6;}}i:21;a:4:{s:1:\"a\";i:22;s:1:\"b\";s:20:\"organizations.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:22;a:4:{s:1:\"a\";i:23;s:1:\"b\";s:21:\"organizations.leaders\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:4:{i:0;i:1;i:1;i:2;i:2;i:6;i:3;i:7;}}i:23;a:4:{s:1:\"a\";i:24;s:1:\"b\";s:15:\"members.migrate\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:24;a:4:{s:1:\"a\";i:25;s:1:\"b\";s:12:\"pledges.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:6:{i:0;i:1;i:1;i:2;i:2;i:5;i:3;i:6;i:4;i:7;i:5;i:8;}}i:25;a:4:{s:1:\"a\";i:26;s:1:\"b\";s:14:\"pledges.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:6:{i:0;i:1;i:1;i:2;i:2;i:5;i:3;i:6;i:4;i:7;i:5;i:8;}}i:26;a:4:{s:1:\"a\";i:27;s:1:\"b\";s:12:\"pledges.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:4:{i:0;i:1;i:1;i:2;i:2;i:6;i:3;i:7;}}i:27;a:4:{s:1:\"a\";i:28;s:1:\"b\";s:14:\"pledges.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:28;a:4:{s:1:\"a\";i:29;s:1:\"b\";s:18:\"contributions.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:6:{i:0;i:1;i:1;i:2;i:2;i:5;i:3;i:6;i:4;i:7;i:5;i:8;}}i:29;a:4:{s:1:\"a\";i:30;s:1:\"b\";s:20:\"contributions.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:6:{i:0;i:1;i:1;i:2;i:2;i:5;i:3;i:6;i:4;i:7;i:5;i:8;}}i:30;a:4:{s:1:\"a\";i:31;s:1:\"b\";s:20:\"contributions.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:31;a:4:{s:1:\"a\";i:32;s:1:\"b\";s:13:\"accounts.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:3:{i:0;i:1;i:1;i:2;i:2;i:6;}}i:32;a:4:{s:1:\"a\";i:33;s:1:\"b\";s:15:\"accounts.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:33;a:4:{s:1:\"a\";i:34;s:1:\"b\";s:13:\"accounts.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:34;a:4:{s:1:\"a\";i:35;s:1:\"b\";s:15:\"accounts.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:35;a:4:{s:1:\"a\";i:36;s:1:\"b\";s:17:\"transactions.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:4:{i:0;i:1;i:1;i:2;i:2;i:6;i:3;i:7;}}i:36;a:4:{s:1:\"a\";i:37;s:1:\"b\";s:19:\"transactions.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:37;a:4:{s:1:\"a\";i:38;s:1:\"b\";s:17:\"transactions.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:38;a:4:{s:1:\"a\";i:39;s:1:\"b\";s:19:\"transactions.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:39;a:4:{s:1:\"a\";i:40;s:1:\"b\";s:20:\"transactions.approve\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:2;}}i:40;a:4:{s:1:\"a\";i:41;s:1:\"b\";s:12:\"budgets.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:3:{i:0;i:1;i:1;i:2;i:2;i:6;}}i:41;a:4:{s:1:\"a\";i:42;s:1:\"b\";s:14:\"budgets.create\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:2;}}i:42;a:4:{s:1:\"a\";i:43;s:1:\"b\";s:12:\"budgets.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:2;}}i:43;a:4:{s:1:\"a\";i:44;s:1:\"b\";s:14:\"budgets.delete\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:44;a:4:{s:1:\"a\";i:45;s:1:\"b\";s:15:\"budgets.approve\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:2:{i:0;i:1;i:1;i:2;}}i:45;a:4:{s:1:\"a\";i:46;s:1:\"b\";s:13:\"settings.view\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}i:46;a:4:{s:1:\"a\";i:47;s:1:\"b\";s:13:\"settings.edit\";s:1:\"c\";s:3:\"web\";s:1:\"r\";a:1:{i:0;i:1;}}}s:5:\"roles\";a:10:{i:0;a:3:{s:1:\"a\";i:1;s:1:\"b\";s:11:\"Super Admin\";s:1:\"c\";s:3:\"web\";}i:1;a:3:{s:1:\"a\";i:2;s:1:\"b\";s:15:\"National Leader\";s:1:\"c\";s:3:\"web\";}i:2;a:3:{s:1:\"a\";i:3;s:1:\"b\";s:12:\"Jimbo Leader\";s:1:\"c\";s:3:\"web\";}i:3;a:3:{s:1:\"a\";i:4;s:1:\"b\";s:12:\"Zonal Leader\";s:1:\"c\";s:3:\"web\";}i:4;a:3:{s:1:\"a\";i:5;s:1:\"b\";s:12:\"Local Leader\";s:1:\"c\";s:3:\"web\";}i:5;a:3:{s:1:\"a\";i:6;s:1:\"b\";s:12:\"Union Leader\";s:1:\"c\";s:3:\"web\";}i:6;a:3:{s:1:\"a\";i:7;s:1:\"b\";s:17:\"Conference Leader\";s:1:\"c\";s:3:\"web\";}i:7;a:3:{s:1:\"a\";i:8;s:1:\"b\";s:11:\"Zone Leader\";s:1:\"c\";s:3:\"web\";}i:8;a:3:{s:1:\"a\";i:10;s:1:\"b\";s:9:\"Treasurer\";s:1:\"c\";s:3:\"web\";}i:9;a:3:{s:1:\"a\";i:9;s:1:\"b\";s:6:\"Member\";s:1:\"c\";s:3:\"web\";}}}',1766838349);
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `communication_logs`
--

DROP TABLE IF EXISTS `communication_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `communication_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `recipient_id` bigint unsigned DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `destination` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `communication_logs_organization_id_foreign` (`organization_id`),
  KEY `communication_logs_recipient_id_foreign` (`recipient_id`),
  CONSTRAINT `communication_logs_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `communication_logs_recipient_id_foreign` FOREIGN KEY (`recipient_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `communication_logs`
--

LOCK TABLES `communication_logs` WRITE;
/*!40000 ALTER TABLE `communication_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `communication_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contributions`
--

DROP TABLE IF EXISTS `contributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contributions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_id` bigint unsigned NOT NULL,
  `transaction_id` bigint unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `purpose` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `pledge_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contributions_member_id_foreign` (`member_id`),
  KEY `contributions_transaction_id_foreign` (`transaction_id`),
  KEY `contributions_pledge_id_foreign` (`pledge_id`),
  CONSTRAINT `contributions_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contributions_pledge_id_foreign` FOREIGN KEY (`pledge_id`) REFERENCES `pledges` (`id`) ON DELETE SET NULL,
  CONSTRAINT `contributions_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contributions`
--

LOCK TABLES `contributions` WRITE;
/*!40000 ALTER TABLE `contributions` DISABLE KEYS */;
INSERT INTO `contributions` VALUES (1,1,1,500000.00,'basi tu','2025-12-26','2025-12-26 08:11:19','2025-12-26 08:11:19',NULL,NULL);
/*!40000 ALTER TABLE `contributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `documents`
--

DROP TABLE IF EXISTS `documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `documentable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `documentable_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `documents_documentable_type_documentable_id_index` (`documentable_type`,`documentable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documents`
--

LOCK TABLES `documents` WRITE;
/*!40000 ALTER TABLE `documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `events`
--

DROP TABLE IF EXISTS `events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start` datetime NOT NULL,
  `end` datetime DEFAULT NULL,
  `organization_id` bigint unsigned DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'General',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `events_organization_id_foreign` (`organization_id`),
  CONSTRAINT `events_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `events`
--

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_batches`
--

DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job_batches`
--

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `levels`
--

DROP TABLE IF EXISTS `levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `levels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `levels_name_unique` (`name`),
  UNIQUE KEY `levels_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `levels`
--

LOCK TABLES `levels` WRITE;
/*!40000 ALTER TABLE `levels` DISABLE KEYS */;
INSERT INTO `levels` VALUES (1,'National','national','2025-12-22 07:08:23','2025-12-22 07:08:23'),(2,'Union','union','2025-12-22 07:08:23','2025-12-22 07:08:23'),(3,'Conference','conference','2025-12-22 07:08:23','2025-12-22 07:08:23'),(4,'Zone','zone','2025-12-22 07:08:23','2025-12-22 07:08:23'),(5,'Local','local','2025-12-22 07:08:23','2025-12-22 07:08:23');
/*!40000 ALTER TABLE `levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meeting_attendees`
--

DROP TABLE IF EXISTS `meeting_attendees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meeting_attendees` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meeting_id` bigint unsigned NOT NULL,
  `member_id` bigint unsigned NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Present',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meeting_attendees_meeting_id_foreign` (`meeting_id`),
  KEY `meeting_attendees_member_id_foreign` (`member_id`),
  CONSTRAINT `meeting_attendees_meeting_id_foreign` FOREIGN KEY (`meeting_id`) REFERENCES `meetings` (`id`) ON DELETE CASCADE,
  CONSTRAINT `meeting_attendees_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meeting_attendees`
--

LOCK TABLES `meeting_attendees` WRITE;
/*!40000 ALTER TABLE `meeting_attendees` DISABLE KEYS */;
/*!40000 ALTER TABLE `meeting_attendees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meetings`
--

DROP TABLE IF EXISTS `meetings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meetings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` datetime NOT NULL,
  `venue` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'General',
  `minutes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meetings_organization_id_foreign` (`organization_id`),
  CONSTRAINT `meetings_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meetings`
--

LOCK TABLES `meetings` WRITE;
/*!40000 ALTER TABLE `meetings` DISABLE KEYS */;
/*!40000 ALTER TABLE `meetings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `members`
--

DROP TABLE IF EXISTS `members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `members` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marital_status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profession` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Member',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `members_organization_id_foreign` (`organization_id`),
  KEY `members_user_id_foreign` (`user_id`),
  CONSTRAINT `members_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `members_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `members`
--

LOCK TABLES `members` WRITE;
/*!40000 ALTER TABLE `members` DISABLE KEYS */;
INSERT INTO `members` VALUES (1,6,NULL,'Zorita','Gonzales','+1 (236) 247-9979','hedulux@mailinator.com','1981-04-20','Female','Aut suscipit omnis q','Magnam error mollit','Professional','Active','2025-12-22 07:19:18','2025-12-26 09:11:48','2025-12-26 09:11:48');
/*!40000 ALTER TABLE `members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permission_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned DEFAULT NULL,
  `route` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menus_parent_id_order_index` (`parent_id`,`order`),
  CONSTRAINT `menus_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Dashboard','dashboard.view',NULL,'dashboard','?',1,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(2,'Organizations','organizations.view',NULL,'organizations.index','?',2,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(3,'Members','members.view',NULL,'members.index','?',3,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(4,'Finance',NULL,NULL,NULL,'?',4,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(5,'Accounts','accounts.view',4,'accounts.index','?',1,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(6,'Transactions','transactions.view',4,'transactions.index','?',2,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(7,'Budgets','budgets.view',4,'budgets.index','?',3,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(8,'Payments',NULL,NULL,NULL,'?',5,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(9,'Pledges','pledges.view',8,'pledges.index','?',1,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(10,'Contributions','contributions.view',8,'contributions.index','?',2,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(11,'Reports','reports.view',NULL,'reports.index','?',6,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(12,'Settings','settings.view',NULL,'settings.index','⚙️',7,1,'2025-12-26 05:36:30','2025-12-26 05:36:30'),(13,'Users','users.view',NULL,'users.index','?',8,1,'2025-12-26 05:36:30','2025-12-26 05:36:30');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0000_cache_tables',1),(2,'0001_auth_tables',1),(3,'0002_membership_tables',1),(4,'0003_finance_tables',1),(5,'0004_payments_tables',1),(6,'0005_budget_tables',1),(7,'0006_project_tables',1),(8,'0007_meeting_tables',1),(9,'0008_activity_tables',1),(10,'0009_audit_tables',1),(11,'0010_jobs_tables',1),(12,'2024_12_22_add_approval_to_transactions',1),(13,'2024_12_22_add_ip_to_audit_logs',1),(14,'2024_12_22_add_pledge_id_to_contributions',1),(15,'2024_12_22_create_organization_leaders_table',1),(16,'2024_12_23_create_menus_table',2),(17,'2025_12_26_111856_add_workflow_fields_to_budgets',3),(18,'2025_12_26_120800_add_soft_deletes_to_tables',4),(19,'2025_12_26_121845_create_settings_table',5);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `organization_leaders`
--

DROP TABLE IF EXISTS `organization_leaders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `organization_leaders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `member_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `position` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `started_at` date NOT NULL,
  `ended_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `organization_leaders_member_id_foreign` (`member_id`),
  KEY `organization_leaders_user_id_foreign` (`user_id`),
  KEY `organization_leaders_organization_id_position_index` (`organization_id`,`position`),
  CONSTRAINT `organization_leaders_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE SET NULL,
  CONSTRAINT `organization_leaders_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `organization_leaders_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `organization_leaders`
--

LOCK TABLES `organization_leaders` WRITE;
/*!40000 ALTER TABLE `organization_leaders` DISABLE KEYS */;
/*!40000 ALTER TABLE `organization_leaders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `organizations`
--

DROP TABLE IF EXISTS `organizations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `organizations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `level_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `organizations_code_unique` (`code`),
  KEY `organizations_level_id_foreign` (`level_id`),
  KEY `organizations_parent_id_foreign` (`parent_id`),
  CONSTRAINT `organizations_level_id_foreign` FOREIGN KEY (`level_id`) REFERENCES `levels` (`id`) ON DELETE CASCADE,
  CONSTRAINT `organizations_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `organizations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `organizations`
--

LOCK TABLES `organizations` WRITE;
/*!40000 ALTER TABLE `organizations` DISABLE KEYS */;
INSERT INTO `organizations` VALUES (1,1,NULL,'ATAPE Tanzania','ATAPE-TZ','Dar es Salaam','2025-12-22 07:08:24','2025-12-22 07:08:24',NULL),(2,2,1,'Eastern Union','EA1',NULL,'2025-12-22 07:09:42','2025-12-22 07:09:42',NULL),(3,2,1,'Southern Union','SA1',NULL,'2025-12-22 07:10:07','2025-12-22 07:10:07',NULL),(4,3,3,'Central Tanzania Conference','SA1-1',NULL,'2025-12-22 07:10:56','2025-12-22 07:10:56',NULL),(5,4,4,'Zanzibar Zone','SA1-1-1',NULL,'2025-12-22 07:17:17','2025-12-22 07:17:17',NULL),(6,5,5,'Zanzibar SDA','SA1-11',NULL,'2025-12-22 07:17:55','2025-12-22 07:17:55',NULL);
/*!40000 ALTER TABLE `organizations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'users.view','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(2,'users.create','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(3,'users.edit','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(4,'users.delete','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(5,'members.view','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(6,'members.create','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(7,'members.edit','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(8,'members.delete','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(9,'members.export','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(10,'finance.view','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(11,'finance.create','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(12,'finance.edit','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(13,'finance.delete','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(14,'finance.approve','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(15,'reports.view','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(16,'reports.export','web','2025-12-22 07:08:23','2025-12-22 07:08:23'),(17,'settings.manage','web','2025-12-22 07:08:24','2025-12-22 07:08:24'),(18,'dashboard.view','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(19,'organizations.view','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(20,'organizations.create','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(21,'organizations.edit','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(22,'organizations.delete','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(23,'organizations.leaders','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(24,'members.migrate','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(25,'pledges.view','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(26,'pledges.create','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(27,'pledges.edit','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(28,'pledges.delete','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(29,'contributions.view','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(30,'contributions.create','web','2025-12-26 05:33:31','2025-12-26 05:33:31'),(31,'contributions.delete','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(32,'accounts.view','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(33,'accounts.create','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(34,'accounts.edit','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(35,'accounts.delete','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(36,'transactions.view','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(37,'transactions.create','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(38,'transactions.edit','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(39,'transactions.delete','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(40,'transactions.approve','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(41,'budgets.view','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(42,'budgets.create','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(43,'budgets.edit','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(44,'budgets.delete','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(45,'budgets.approve','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(46,'settings.view','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(47,'settings.edit','web','2025-12-26 05:33:32','2025-12-26 05:33:32');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pledges`
--

DROP TABLE IF EXISTS `pledges`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pledges` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_id` bigint unsigned NOT NULL,
  `year` int NOT NULL,
  `purpose` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `paid_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pledges_member_id_foreign` (`member_id`),
  CONSTRAINT `pledges_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pledges`
--

LOCK TABLES `pledges` WRITE;
/*!40000 ALTER TABLE `pledges` DISABLE KEYS */;
/*!40000 ALTER TABLE `pledges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_milestones`
--

DROP TABLE IF EXISTS `project_milestones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_milestones` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `due_date` date DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `project_milestones_project_id_foreign` (`project_id`),
  CONSTRAINT `project_milestones_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_milestones`
--

LOCK TABLES `project_milestones` WRITE;
/*!40000 ALTER TABLE `project_milestones` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_milestones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `budget` decimal(15,2) NOT NULL DEFAULT '0.00',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Planned',
  `leader_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projects_organization_id_foreign` (`organization_id`),
  KEY `projects_leader_id_foreign` (`leader_id`),
  CONSTRAINT `projects_leader_id_foreign` FOREIGN KEY (`leader_id`) REFERENCES `members` (`id`) ON DELETE SET NULL,
  CONSTRAINT `projects_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Super Admin','web','2025-12-22 07:08:24','2025-12-22 07:08:24'),(2,'National Leader','web','2025-12-22 07:08:24','2025-12-22 07:08:24'),(3,'Jimbo Leader','web','2025-12-22 07:08:24','2025-12-22 07:08:24'),(4,'Zonal Leader','web','2025-12-22 07:08:24','2025-12-22 07:08:24'),(5,'Local Leader','web','2025-12-22 07:08:24','2025-12-22 07:08:24'),(6,'Union Leader','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(7,'Conference Leader','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(8,'Zone Leader','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(9,'Member','web','2025-12-26 05:33:32','2025-12-26 05:33:32'),(10,'Treasurer','web','2025-12-26 09:25:49','2025-12-26 09:25:49');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles_permissions`
--

DROP TABLE IF EXISTS `roles_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `roles_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `roles_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `roles_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles_permissions`
--

LOCK TABLES `roles_permissions` WRITE;
/*!40000 ALTER TABLE `roles_permissions` DISABLE KEYS */;
INSERT INTO `roles_permissions` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(5,2),(6,2),(7,2),(9,2),(15,2),(16,2),(18,2),(19,2),(20,2),(21,2),(23,2),(25,2),(26,2),(27,2),(29,2),(30,2),(32,2),(36,2),(40,2),(41,2),(42,2),(43,2),(45,2),(5,3),(6,3),(7,3),(9,3),(10,3),(15,3),(16,3),(5,4),(6,4),(7,4),(10,4),(15,4),(5,5),(6,5),(7,5),(18,5),(19,5),(25,5),(26,5),(29,5),(30,5),(5,6),(6,6),(7,6),(9,6),(15,6),(16,6),(18,6),(19,6),(21,6),(23,6),(25,6),(26,6),(27,6),(29,6),(30,6),(32,6),(36,6),(41,6),(5,7),(6,7),(7,7),(15,7),(18,7),(19,7),(23,7),(25,7),(26,7),(27,7),(29,7),(30,7),(36,7),(5,8),(6,8),(7,8),(15,8),(18,8),(19,8),(25,8),(26,8),(29,8),(30,8),(18,9),(10,10),(11,10),(12,10),(13,10),(14,10);
/*!40000 ALTER TABLE `roles_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` VALUES ('uSn2wEjiE6lA1FF9Aqtz5YqU4zhBO0wXvLu9DgOh',1,'127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiUmJ4eUxCbmt1R2J0d01maDl2Z2ZVbEdQczR4bmFlRloxc0JvcjI3QSI7czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6MzE6Imh0dHA6Ly8xMjcuMC4wLjE6ODAwMC9kYXNoYm9hcmQiO3M6NToicm91dGUiO3M6OToiZGFzaGJvYXJkIjt9czo1MDoibG9naW5fd2ViXzU5YmEzNmFkZGMyYjJmOTQwMTU4MGYwMTRjN2Y1OGVhNGUzMDk4OWQiO2k6MTt9',1766755332),('wESEeDskXKsGcfLz172vXKvp5GhdyOUBbSV32ynm',1,'127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36','YTo0OntzOjY6Il90b2tlbiI7czo0MDoibUxBMVozV0JDa0JyQ2l2bHF1NFNSQmFCc3dIWGlFTjVKY2VkUUg4YyI7czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6MzE6Imh0dHA6Ly8xMjcuMC4wLjE6ODAwMC9kYXNoYm9hcmQiO3M6NToicm91dGUiO3M6OToiZGFzaGJvYXJkIjt9czo1MDoibG9naW5fd2ViXzU5YmEzNmFkZGMyYjJmOTQwMTU4MGYwMTRjN2Y1OGVhNGUzMDk4OWQiO2k6MTt9',1766755676);
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'general',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'string',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'organization_name','Eastern Union','general','string','Organization name','2025-12-26 09:27:40','2025-12-26 09:41:42',NULL),(2,'fiscal_year_start','January','general','string','Fiscal year start','2025-12-26 09:27:40','2025-12-26 09:27:40',NULL),(3,'currency_symbol','TZS','general','string','Currency symbol','2025-12-26 09:27:40','2025-12-26 09:27:40',NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transaction_categories`
--

DROP TABLE IF EXISTS `transaction_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_categories_organization_id_foreign` (`organization_id`),
  CONSTRAINT `transaction_categories_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transaction_categories`
--

LOCK TABLES `transaction_categories` WRITE;
/*!40000 ALTER TABLE `transaction_categories` DISABLE KEYS */;
INSERT INTO `transaction_categories` VALUES (1,NULL,'Membership Fees','Income','2025-12-22 07:08:24','2025-12-22 07:08:24'),(2,NULL,'Donations','Income','2025-12-22 07:08:24','2025-12-22 07:08:24'),(3,NULL,'Tithes','Income','2025-12-22 07:08:24','2025-12-22 07:08:24'),(4,NULL,'Project Contributions','Income','2025-12-22 07:08:24','2025-12-22 07:08:24'),(5,NULL,'Events Income','Income','2025-12-22 07:08:24','2025-12-22 07:08:24'),(6,NULL,'Other Income','Income','2025-12-22 07:08:24','2025-12-22 07:08:24'),(7,NULL,'Office Supplies','Expense','2025-12-22 07:08:24','2025-12-22 07:08:24'),(8,NULL,'Transport','Expense','2025-12-22 07:08:24','2025-12-22 07:08:24'),(9,NULL,'Welfare','Expense','2025-12-22 07:08:24','2025-12-22 07:08:24'),(10,NULL,'Events Expenses','Expense','2025-12-22 07:08:24','2025-12-22 07:08:24'),(11,NULL,'Project Expenses','Expense','2025-12-22 07:08:24','2025-12-22 07:08:24'),(12,NULL,'Communication','Expense','2025-12-22 07:08:24','2025-12-22 07:08:24'),(13,NULL,'Other Expenses','Expense','2025-12-22 07:08:24','2025-12-22 07:08:24');
/*!40000 ALTER TABLE `transaction_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `organization_id` bigint unsigned NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `date` date NOT NULL,
  `recorded_by` bigint unsigned NOT NULL,
  `status` enum('Pending','Approved','Rejected') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Approved',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` timestamp NULL DEFAULT NULL,
  `rejection_reason` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_organization_id_foreign` (`organization_id`),
  KEY `transactions_account_id_foreign` (`account_id`),
  KEY `transactions_category_id_foreign` (`category_id`),
  KEY `transactions_recorded_by_foreign` (`recorded_by`),
  KEY `transactions_approved_by_foreign` (`approved_by`),
  CONSTRAINT `transactions_account_id_foreign` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `transactions_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `transaction_categories` (`id`),
  CONSTRAINT `transactions_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_recorded_by_foreign` FOREIGN KEY (`recorded_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transactions`
--

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES (1,5,1,2,500000.00,'Credit','23423432','Contribution from Zorita Gonzales: basi tu','2025-12-26',1,'Approved','2025-12-26 08:11:19','2025-12-26 08:11:19',NULL,NULL,NULL,NULL),(2,5,1,6,1000000000.00,'Credit',NULL,NULL,'2025-12-26',1,'Approved','2025-12-26 08:12:45','2025-12-26 08:12:45',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `organization_id` bigint unsigned DEFAULT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'system',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`),
  UNIQUE KEY `users_phone_unique` (`phone`),
  KEY `users_organization_id_foreign` (`organization_id`),
  KEY `users_domain_index` (`domain`),
  CONSTRAINT `users_organization_id_foreign` FOREIGN KEY (`organization_id`) REFERENCES `organizations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'superadmin','System','Administrator','admin@atape.or.tz',NULL,NULL,'$2y$12$ISOb5rs.dWNuTl75aNFKmuBAnU2MOqAjZgqQ3C9S3GQ1rT1uUJ75G',1,'system',1,NULL,'2025-12-22 07:08:24','2025-12-26 09:03:29',NULL),(2,NULL,'Jane','Smith','jane@atape.or.tz',NULL,NULL,'$2y$12$.Nql0ivurRGa7CnQbiBSqOnXLYyWcB/PpPVmVNQoqZZo.H7o/H1me',NULL,'system',1,NULL,'2025-12-26 07:57:12','2025-12-26 08:36:12',NULL),(3,NULL,'Kenneth','Bauer','bidix@mailinator.com',NULL,NULL,'$2y$12$0B480LGK6uBduVoBVBwvwen1MHYdHEN5fy1yKeKmyFxbadd1Dig4u',4,'system',1,NULL,'2025-12-26 07:57:55','2025-12-26 07:58:41',NULL),(4,NULL,'Budget','Checker','checker@atape.or.tz',NULL,NULL,'$2y$12$0ULun8c.SluICsX9zZNU5OwO6hiUeCIE.rsoU0fJYLXg76WsqipCy',NULL,'system',1,NULL,'2025-12-26 08:33:08','2025-12-26 08:33:08',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_permissions`
--

DROP TABLE IF EXISTS `users_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `users_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_permissions`
--

LOCK TABLES `users_permissions` WRITE;
/*!40000 ALTER TABLE `users_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_roles`
--

DROP TABLE IF EXISTS `users_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `users_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_roles`
--

LOCK TABLES `users_roles` WRITE;
/*!40000 ALTER TABLE `users_roles` DISABLE KEYS */;
INSERT INTO `users_roles` VALUES (1,'App\\Models\\User',1),(9,'App\\Models\\User',2),(7,'App\\Models\\User',3),(1,'App\\Models\\User',4),(2,'App\\Models\\User',4);
/*!40000 ALTER TABLE `users_roles` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2026-01-05  9:52:18
