<?php

namespace App\Models;

use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contribution extends Model
{
    use HasFactory, Auditable, SoftDeletes;

    protected $fillable = [
        'member_id',
        'transaction_id',
        'pledge_id',
        'amount',
        'purpose',
        'date',
    ];

    protected function casts(): array
    {
        return [
            'amount' => 'decimal:2',
            'date' => 'date',
        ];
    }

    /**
     * Boot method to update pledge status when contribution is made.
     */
    protected static function booted(): void
    {
        static::created(function (Contribution $contribution) {
            if ($contribution->pledge_id) {
                $pledge = $contribution->pledge;
                $pledge->paid_amount += $contribution->amount;
                $pledge->updateStatus();
            }
        });

        static::deleted(function (Contribution $contribution) {
            if ($contribution->pledge_id) {
                $pledge = $contribution->pledge;
                $pledge->paid_amount -= $contribution->amount;
                $pledge->updateStatus();
            }
        });
    }

    public function member(): BelongsTo
    {
        return $this->belongsTo(Member::class);
    }

    public function transaction(): BelongsTo
    {
        return $this->belongsTo(Transaction::class);
    }

    public function pledge(): BelongsTo
    {
        return $this->belongsTo(Pledge::class);
    }
}
