<?php

namespace App\Models;

use App\Traits\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrganizationLeader extends Model
{
    use HasFactory, Auditable;

    protected $fillable = [
        'organization_id',
        'member_id',
        'user_id',
        'position',
        'started_at',
        'ended_at',
    ];

    protected function casts(): array
    {
        return [
            'started_at' => 'date',
            'ended_at' => 'date',
        ];
    }

    /**
     * Check if currently active.
     */
    public function getIsActiveAttribute(): bool
    {
        return $this->ended_at === null || $this->ended_at->isFuture();
    }

    public function organization(): BelongsTo
    {
        return $this->belongsTo(Organization::class);
    }

    public function member(): BelongsTo
    {
        return $this->belongsTo(Member::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the leader name (from member or user).
     */
    public function getLeaderNameAttribute(): string
    {
        if ($this->member) {
            return $this->member->full_name;
        }
        if ($this->user) {
            return $this->user->full_name;
        }
        return 'Unknown';
    }

    /**
     * Available positions.
     */
    public static function positions(): array
    {
        return [
            'Chairman',
            'Vice Chairman',
            'Secretary',
            'Treasurer',
            'Chaplain',
            'Organizing Secretary',
            'Committee Member',
        ];
    }
}
