<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Strategic Plan Items
        Schema::create('activity_plans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('organization_id')->constrained('organizations')->cascadeOnDelete();
            $table->integer('year');
            $table->string('objective');
            $table->string('activity_type'); // Seminar, Outreach, etc.
            $table->string('target_group')->nullable();
            $table->string('venue')->nullable();
            $table->decimal('budget_est', 15, 2)->default(0);
            $table->string('status')->default('Pending'); // Pending, Approved
            $table->timestamps();
        });

        // Actual Calendar Events
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->dateTime('start');
            $table->dateTime('end')->nullable();
            $table->foreignId('organization_id')->nullable()->constrained('organizations')->cascadeOnDelete();
            $table->string('type')->default('General');
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events');
        Schema::dropIfExists('activity_plans');
    }
};
