<?php

namespace Database\Seeders;

use App\Models\Level;
use App\Models\Organization;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get National Level
        $nationalLevel = Level::where('slug', 'national')->first();

        // Create National Organization (ATAPE Tanzania)
        $nationalOrg = Organization::firstOrCreate(
            ['code' => 'ATAPE-TZ'],
            [
                'level_id' => $nationalLevel->id,
                'name' => 'ATAPE Tanzania',
                'location' => 'Dar es Salaam',
            ]
        );

        // Create Super Admin
        $admin = User::firstOrCreate(
            ['email' => 'admin@atape.or.tz'],
            [
                'username' => 'superadmin',
                'first_name' => 'System',
                'last_name' => 'Administrator',
                'password' => Hash::make('password'),
                'organization_id' => $nationalOrg->id,
                'domain' => 'system',
                'is_active' => true,
            ]
        );

        $admin->assignRole('Super Admin');
    }
}
