<?php

namespace Database\Seeders;

use App\Models\Level;
use Illuminate\Database\Seeder;

class LevelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     * 
     * Hierarchy: National → Union → Conference → Zone → Local
     */
    public function run(): void
    {
        $levels = [
            ['name' => 'National', 'slug' => 'national'],
            ['name' => 'Union', 'slug' => 'union'],
            ['name' => 'Conference', 'slug' => 'conference'],
            ['name' => 'Zone', 'slug' => 'zone'],
            ['name' => 'Local', 'slug' => 'local'],
        ];

        foreach ($levels as $level) {
            Level::firstOrCreate(['slug' => $level['slug']], $level);
        }
    }
}

