<?php

namespace Database\Seeders;

use App\Models\Menu;
use Illuminate\Database\Seeder;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Clear existing menus
        Menu::truncate();

        // Top-level menus
        $dashboard = Menu::create([
            'name' => 'Dashboard',
            'permission_name' => 'dashboard.view',
            'route' => 'dashboard',
            'icon' => '📊',
            'order' => 1,
        ]);

        $organizations = Menu::create([
            'name' => 'Organizations',
            'permission_name' => 'organizations.view',
            'route' => 'organizations.index',
            'icon' => '🏢',
            'order' => 2,
        ]);

        $members = Menu::create([
            'name' => 'Members',
            'permission_name' => 'members.view',
            'route' => 'members.index',
            'icon' => '👥',
            'order' => 3,
        ]);

        // Finance dropdown (parent)
        $finance = Menu::create([
            'name' => 'Finance',
            'permission_name' => null, // Parent doesn't need permission, children do
            'route' => null,
            'icon' => '💰',
            'order' => 4,
        ]);

        Menu::create([
            'name' => 'Accounts',
            'permission_name' => 'accounts.view',
            'route' => 'accounts.index',
            'icon' => '🏦',
            'order' => 1,
            'parent_id' => $finance->id,
        ]);

        Menu::create([
            'name' => 'Transactions',
            'permission_name' => 'transactions.view',
            'route' => 'transactions.index',
            'icon' => '💳',
            'order' => 2,
            'parent_id' => $finance->id,
        ]);

        Menu::create([
            'name' => 'Budgets',
            'permission_name' => 'budgets.view',
            'route' => 'budgets.index',
            'icon' => '📈',
            'order' => 3,
            'parent_id' => $finance->id,
        ]);

        // Payments dropdown (parent)
        $payments = Menu::create([
            'name' => 'Payments',
            'permission_name' => null,
            'route' => null,
            'icon' => '💵',
            'order' => 5,
        ]);

        Menu::create([
            'name' => 'Pledges',
            'permission_name' => 'pledges.view',
            'route' => 'pledges.index',
            'icon' => '🤝',
            'order' => 1,
            'parent_id' => $payments->id,
        ]);

        Menu::create([
            'name' => 'Contributions',
            'permission_name' => 'contributions.view',
            'route' => 'contributions.index',
            'icon' => '🎁',
            'order' => 2,
            'parent_id' => $payments->id,
        ]);

        // Reports
        Menu::create([
            'name' => 'Reports',
            'permission_name' => 'reports.view',
            'route' => 'reports.index',
            'icon' => '📋',
            'order' => 6,
        ]);

        // Settings (admin)
        Menu::create([
            'name' => 'Settings',
            'permission_name' => 'settings.view',
            'route' => 'settings.index',
            'icon' => '⚙️',
            'order' => 7,
        ]);

        // Users (admin)
        Menu::create([
            'name' => 'Users',
            'permission_name' => 'users.view',
            'route' => 'users.index',
            'icon' => '👤',
            'order' => 8,
        ]);
    }
}
