<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Define all permissions by module
        $permissions = [
            // Dashboard
            'dashboard.view',
            
            // Organizations
            'organizations.view', 'organizations.create', 'organizations.edit', 
            'organizations.delete', 'organizations.leaders',
            
            // Members
            'members.view', 'members.create', 'members.edit', 
            'members.delete', 'members.export', 'members.migrate',
            
            // Pledges
            'pledges.view', 'pledges.create', 'pledges.edit', 'pledges.delete',
            
            // Contributions
            'contributions.view', 'contributions.create', 'contributions.delete',
            
            // Accounts
            'accounts.view', 'accounts.create', 'accounts.edit', 'accounts.delete',
            
            // Transactions
            'transactions.view', 'transactions.create', 'transactions.edit', 
            'transactions.delete', 'transactions.approve',
            
            // Budgets
            'budgets.view', 'budgets.create', 'budgets.edit', 
            'budgets.delete', 'budgets.approve',
            
            // Users
            'users.view', 'users.create', 'users.edit', 'users.delete',
            
            // Reports
            'reports.view', 'reports.export',
            
            // Settings
            'settings.view', 'settings.edit',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
        }

        // ===== Create Roles and Assign Permissions =====

        // Super Admin - All permissions
        $superAdmin = Role::firstOrCreate(['name' => 'Super Admin', 'guard_name' => 'web']);
        $superAdmin->syncPermissions(Permission::all());

        // National Leader - Full access except user management
        $nationalLeader = Role::firstOrCreate(['name' => 'National Leader', 'guard_name' => 'web']);
        $nationalLeader->syncPermissions([
            'dashboard.view',
            'organizations.view', 'organizations.create', 'organizations.edit', 'organizations.leaders',
            'members.view', 'members.create', 'members.edit', 'members.export',
            'pledges.view', 'pledges.create', 'pledges.edit',
            'contributions.view', 'contributions.create',
            'accounts.view',
            'transactions.view', 'transactions.approve',
            'budgets.view', 'budgets.create', 'budgets.edit', 'budgets.approve',
            'reports.view', 'reports.export',
        ]);

        // Union Leader
        $unionLeader = Role::firstOrCreate(['name' => 'Union Leader', 'guard_name' => 'web']);
        $unionLeader->syncPermissions([
            'dashboard.view',
            'organizations.view', 'organizations.edit', 'organizations.leaders',
            'members.view', 'members.create', 'members.edit', 'members.export',
            'pledges.view', 'pledges.create', 'pledges.edit',
            'contributions.view', 'contributions.create',
            'accounts.view',
            'transactions.view',
            'budgets.view',
            'reports.view', 'reports.export',
        ]);

        // Conference Leader
        $conferenceLeader = Role::firstOrCreate(['name' => 'Conference Leader', 'guard_name' => 'web']);
        $conferenceLeader->syncPermissions([
            'dashboard.view',
            'organizations.view', 'organizations.leaders',
            'members.view', 'members.create', 'members.edit',
            'pledges.view', 'pledges.create', 'pledges.edit',
            'contributions.view', 'contributions.create',
            'transactions.view',
            'reports.view',
        ]);

        // Zone Leader
        $zoneLeader = Role::firstOrCreate(['name' => 'Zone Leader', 'guard_name' => 'web']);
        $zoneLeader->syncPermissions([
            'dashboard.view',
            'organizations.view',
            'members.view', 'members.create', 'members.edit',
            'pledges.view', 'pledges.create',
            'contributions.view', 'contributions.create',
            'reports.view',
        ]);

        // Local Leader
        $localLeader = Role::firstOrCreate(['name' => 'Local Leader', 'guard_name' => 'web']);
        $localLeader->syncPermissions([
            'dashboard.view',
            'organizations.view',
            'members.view', 'members.create', 'members.edit',
            'pledges.view', 'pledges.create',
            'contributions.view', 'contributions.create',
        ]);

        // Member (basic access)
        $member = Role::firstOrCreate(['name' => 'Member', 'guard_name' => 'web']);
        $member->syncPermissions([
            'dashboard.view',
        ]);
    }
}

