<?php

namespace Database\Seeders;

use App\Models\TransactionCategory;
use Illuminate\Database\Seeder;

class TransactionCategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            // Income categories
            ['name' => 'Membership Fees', 'type' => 'Income'],
            ['name' => 'Donations', 'type' => 'Income'],
            ['name' => 'Tithes', 'type' => 'Income'],
            ['name' => 'Project Contributions', 'type' => 'Income'],
            ['name' => 'Events Income', 'type' => 'Income'],
            ['name' => 'Other Income', 'type' => 'Income'],
            
            // Expense categories
            ['name' => 'Office Supplies', 'type' => 'Expense'],
            ['name' => 'Transport', 'type' => 'Expense'],
            ['name' => 'Welfare', 'type' => 'Expense'],
            ['name' => 'Events Expenses', 'type' => 'Expense'],
            ['name' => 'Project Expenses', 'type' => 'Expense'],
            ['name' => 'Communication', 'type' => 'Expense'],
            ['name' => 'Other Expenses', 'type' => 'Expense'],
        ];

        foreach ($categories as $category) {
            TransactionCategory::firstOrCreate(
                ['name' => $category['name']],
                $category
            );
        }
    }
}
