<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class WorkflowTestUserSeeder extends Seeder
{
    public function run(): void
    {
        $role = Role::where('name', 'National Leader')->firstOrFail();

        $user = User::firstOrCreate(
            ['email' => 'checker@atape.or.tz'],
            [
                'first_name' => 'Checker',
                'last_name' => 'Test',
                'password' => Hash::make('password'),
                'organization_id' => 1, // Assuming org 1 exists
                'is_active' => true,
            ]
        );

        if (!$user->hasRole('National Leader')) {
            $user->assignRole($role);
        }
    }
}
