@extends('layouts.app')

@section('title', 'Create Budget')

@section('content')
<div class="page-header">
    <h1>Create New Budget</h1>
    <p class="text-muted">Create an annual financial plan</p>
</div>

<div class="form-card">
    <form action="{{ route('budgets.store') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="organization_id">Organization *</label>
            <select id="organization_id" name="organization_id" required>
                <option value="">Select Organization...</option>
                @foreach($organizations as $org)
                <option value="{{ $org->id }}" {{ old('organization_id') == $org->id ? 'selected' : '' }}>
                    {{ $org->name }}
                </option>
                @endforeach
            </select>
            @error('organization_id')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-group">
            <label for="fiscal_year">Fiscal Year *</label>
            <select id="fiscal_year" name="fiscal_year" required>
                @for($y = date('Y') + 1; $y >= date('Y') - 2; $y--)
                <option value="{{ $y }}" {{ old('fiscal_year', date('Y')) == $y ? 'selected' : '' }}>{{ $y }}</option>
                @endfor
            </select>
            @error('fiscal_year')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-actions">
            <a href="{{ route('budgets.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Create Budget</button>
        </div>
    </form>
</div>
@endsection
