@extends('layouts.app')

@section('title', 'Budgets')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Budgets</h1>
        <p class="text-muted">Annual financial plans and budgets</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('budgets.create') }}" class="btn btn-primary">+ Create Budget</a>
    </div>
</div>

<div class="filters-card">
    <form action="{{ route('budgets.index') }}" method="GET" class="filters-form">
        <div class="filter-group">
            <select name="year">
                <option value="">All Years</option>
                @for($y = date('Y') + 1; $y >= 2020; $y--)
                <option value="{{ $y }}" {{ request('year') == $y ? 'selected' : '' }}>{{ $y }}</option>
                @endfor
            </select>
        </div>
        <div class="filter-group">
            <select name="status">
                <option value="">All Statuses</option>
                <option value="Draft" {{ request('status') == 'Draft' ? 'selected' : '' }}>Draft</option>
                <option value="Approved" {{ request('status') == 'Approved' ? 'selected' : '' }}>Approved</option>
            </select>
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
    </form>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Organization</th>
                <th>Fiscal Year</th>
                <th>Total Income</th>
                <th>Total Expense</th>
                <th>Net Balance</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($budgets as $budget)
            <tr>
                <td><strong>{{ $budget->organization?->name }}</strong></td>
                <td>{{ $budget->fiscal_year }}</td>
                <td class="text-success">{{ number_format($budget->total_income, 2) }}</td>
                <td class="text-danger">{{ number_format($budget->total_expense, 2) }}</td>
                <td class="{{ $budget->net_balance >= 0 ? 'text-success' : 'text-danger' }}">
                    {{ number_format($budget->net_balance, 2) }}
                </td>
                <td>
                    @if($budget->status === 'Draft')
                        <span class="badge badge-warning">Draft</span>
                    @else
                        <span class="badge badge-success">Approved</span>
                    @endif
                </td>
                <td>
                    <a href="{{ route('budgets.show', $budget) }}" class="btn btn-sm btn-link">👁️</a>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="7" class="empty-state">No budgets found.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        {{ $budgets->links() }}
    </div>
</div>
@endsection
