@extends('layouts.app')

@section('title', 'Add Account')

@section('content')
<div class="page-header">
    <h1>Add New Account</h1>
    <p class="text-muted">Create a new financial account</p>
</div>

<div class="form-card">
    <form action="{{ route('accounts.store') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="name">Account Name *</label>
            <input type="text" id="name" name="name" value="{{ old('name') }}" required placeholder="e.g., CRDB Bank Account">
            @error('name')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="type">Account Type *</label>
                <select id="type" name="type" required>
                    <option value="Bank" {{ old('type') == 'Bank' ? 'selected' : '' }}>Bank</option>
                    <option value="Mobile" {{ old('type') == 'Mobile' ? 'selected' : '' }}>Mobile Money</option>
                    <option value="Cash" {{ old('type') == 'Cash' ? 'selected' : '' }}>Cash</option>
                </select>
            </div>
            <div class="form-group">
                <label for="currency">Currency *</label>
                <input type="text" id="currency" name="currency" value="{{ old('currency', 'TZS') }}" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="organization_id">Organization *</label>
            <select id="organization_id" name="organization_id" required>
                <option value="">Select Organization...</option>
                @foreach($organizations as $org)
                <option value="{{ $org->id }}" {{ old('organization_id') == $org->id ? 'selected' : '' }}>{{ $org->name }}</option>
                @endforeach
            </select>
            @error('organization_id')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-actions">
            <a href="{{ route('accounts.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Create Account</button>
        </div>
    </form>
</div>
@endsection
