@extends('layouts.app')

@section('title', 'Edit Account')

@section('content')
<div class="page-header">
    <h1>Edit Account</h1>
    <p class="text-muted">Update account information</p>
</div>

<div class="form-card">
    <form action="{{ route('accounts.update', $account) }}" method="POST">
        @csrf
        @method('PUT')
        
        <div class="form-group">
            <label for="name">Account Name *</label>
            <input type="text" id="name" name="name" value="{{ old('name', $account->name) }}" required>
            @error('name')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="type">Account Type *</label>
                <select id="type" name="type" required>
                    <option value="Bank" {{ old('type', $account->type) == 'Bank' ? 'selected' : '' }}>Bank</option>
                    <option value="Mobile" {{ old('type', $account->type) == 'Mobile' ? 'selected' : '' }}>Mobile Money</option>
                    <option value="Cash" {{ old('type', $account->type) == 'Cash' ? 'selected' : '' }}>Cash</option>
                </select>
            </div>
            <div class="form-group">
                <label for="currency">Currency *</label>
                <input type="text" id="currency" name="currency" value="{{ old('currency', $account->currency) }}" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="organization_id">Organization *</label>
            <select id="organization_id" name="organization_id" required>
                @foreach($organizations as $org)
                <option value="{{ $org->id }}" {{ old('organization_id', $account->organization_id) == $org->id ? 'selected' : '' }}>{{ $org->name }}</option>
                @endforeach
            </select>
        </div>
        
        <div class="alert alert-info" style="margin-top: 1rem;">
            <strong>Current Balance:</strong> {{ number_format($account->balance, 2) }} {{ $account->currency }}
        </div>
        
        <div class="form-actions">
            <a href="{{ route('accounts.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Update Account</button>
        </div>
    </form>
</div>
@endsection
