@extends('layouts.app')

@section('title', 'Accounts')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Accounts</h1>
        <p class="text-muted">Manage your organization's financial accounts</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('accounts.create') }}" class="btn btn-primary">+ Add Account</a>
    </div>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Account Name</th>
                <th>Type</th>
                <th>Organization</th>
                <th>Balance</th>
                <th>Currency</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($accounts as $account)
            <tr>
                <td><strong>{{ $account->name }}</strong></td>
                <td><span class="badge badge-info">{{ $account->type }}</span></td>
                <td>{{ $account->organization?->name }}</td>
                <td class="{{ $account->balance >= 0 ? 'text-success' : 'text-danger' }}">
                    {{ number_format($account->balance, 2) }}
                </td>
                <td>{{ $account->currency }}</td>
                <td>
                    <div class="action-buttons">
                        <a href="{{ route('accounts.edit', $account) }}" class="btn btn-sm btn-link">✏️</a>
                        <form action="{{ route('accounts.destroy', $account) }}" method="POST" style="display:inline;" onsubmit="return confirm('Delete this account?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-link">🗑️</button>
                        </form>
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="6" class="empty-state">No accounts found. Create your first account.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        {{ $accounts->links() }}
    </div>
</div>
@endsection
