@extends('layouts.app')

@section('title', 'Record Transaction')

@section('content')
<div class="page-header">
    <h1>Record Transaction</h1>
    <p class="text-muted">Record income or expense</p>
</div>

<div class="form-card">
    <form action="{{ route('transactions.store') }}" method="POST">
        @csrf
        
        <div class="form-row">
            <div class="form-group">
                <label for="type">Transaction Type *</label>
                <select id="type" name="type" required>
                    <option value="Credit" {{ old('type') == 'Credit' ? 'selected' : '' }}>💰 Income (Credit)</option>
                    <option value="Debit" {{ old('type') == 'Debit' ? 'selected' : '' }}>💸 Expense (Debit)</option>
                </select>
            </div>
            <div class="form-group">
                <label for="date">Date *</label>
                <input type="date" id="date" name="date" value="{{ old('date', date('Y-m-d')) }}" required>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="account_id">Account *</label>
                <select id="account_id" name="account_id" required>
                    <option value="">Select Account...</option>
                    @foreach($accounts as $account)
                    <option value="{{ $account->id }}" {{ old('account_id') == $account->id ? 'selected' : '' }}>
                        {{ $account->name }} ({{ $account->currency }} {{ number_format($account->balance, 2) }})
                    </option>
                    @endforeach
                </select>
                @error('account_id')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="category_id">Category *</label>
                <select id="category_id" name="category_id" required>
                    <option value="">Select Category...</option>
                    @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                        {{ $category->name }} ({{ $category->type }})
                    </option>
                    @endforeach
                </select>
                @error('category_id')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="amount">Amount *</label>
                <div class="currency-input">
                    <input type="number" id="amount" name="amount" value="{{ old('amount') }}" step="0.01" min="0.01" required placeholder="0.00">
                </div>
                @error('amount')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="reference">Reference Number</label>
                <input type="text" id="reference" name="reference" value="{{ old('reference') }}" placeholder="e.g., Receipt #12345">
            </div>
        </div>
        
        <div class="form-group">
            <label for="description">Description</label>
            <textarea id="description" name="description" rows="3" placeholder="Transaction details...">{{ old('description') }}</textarea>
        </div>
        
        <div class="form-actions">
            <a href="{{ route('transactions.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Record Transaction</button>
        </div>
    </form>
</div>
@endsection
