@extends('layouts.app')

@section('title', 'Transactions')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Transactions</h1>
        <p class="text-muted">View and record financial transactions</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('transactions.pending') }}" class="btn btn-secondary">⏳ Pending Approvals</a>
        <a href="{{ route('transactions.export', request()->query()) }}" class="btn btn-secondary">Export CSV</a>
        <a href="{{ route('transactions.create') }}" class="btn btn-primary">+ Record Transaction</a>
    </div>
</div>

<!-- Filters -->
<div class="filters-card">
    <form action="{{ route('transactions.index') }}" method="GET" class="filters-form">
        <div class="filter-group">
            <input type="text" name="search" placeholder="Search reference or description..." value="{{ request('search') }}">
        </div>
        <div class="filter-group">
            <select name="type">
                <option value="">All Types</option>
                <option value="Credit" {{ request('type') == 'Credit' ? 'selected' : '' }}>Income (Credit)</option>
                <option value="Debit" {{ request('type') == 'Debit' ? 'selected' : '' }}>Expense (Debit)</option>
            </select>
        </div>
        <div class="filter-group">
            <select name="account_id">
                <option value="">All Accounts</option>
                @foreach($accounts as $account)
                <option value="{{ $account->id }}" {{ request('account_id') == $account->id ? 'selected' : '' }}>{{ $account->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="filter-group">
            <input type="date" name="date_from" value="{{ request('date_from') }}" placeholder="From">
        </div>
        <div class="filter-group">
            <input type="date" name="date_to" value="{{ request('date_to') }}" placeholder="To">
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
        <a href="{{ route('transactions.index') }}" class="btn btn-link">Clear</a>
    </form>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Type</th>
                <th>Status</th>
                <th>Account</th>
                <th>Category</th>
                <th>Amount</th>
                <th>Reference</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($transactions as $transaction)
            <tr>
                <td>{{ $transaction->date->format('d M Y') }}</td>
                <td>
                    <span class="badge badge-{{ $transaction->type == 'Credit' ? 'success' : 'danger' }}">
                        {{ $transaction->type == 'Credit' ? '+ Income' : '- Expense' }}
                    </span>
                </td>
                <td>
                    @if($transaction->status === 'Pending')
                        <span class="badge badge-warning">⏳ Pending</span>
                    @elseif($transaction->status === 'Approved')
                        <span class="badge badge-success">✅ Approved</span>
                    @else
                        <span class="badge badge-danger">❌ Rejected</span>
                    @endif
                </td>
                <td>{{ $transaction->account?->name }}</td>
                <td>{{ $transaction->category?->name }}</td>
                <td class="{{ $transaction->type == 'Credit' ? 'text-success' : 'text-danger' }}">
                    {{ number_format($transaction->amount, 2) }}
                </td>
                <td>{{ $transaction->reference ?? '-' }}</td>
                <td>
                    <div class="action-buttons">
                        <a href="{{ route('transactions.show', $transaction) }}" class="btn btn-sm btn-link">👁️</a>
                        @if($transaction->status === 'Approved')
                        <form action="{{ route('transactions.destroy', $transaction) }}" method="POST" style="display:inline;" data-confirm="Delete and reverse balance? This action cannot be undone.">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-link">🗑️</button>
                        </form>
                        @endif
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="8" class="empty-state">No transactions found.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        {{ $transactions->links() }}
    </div>
</div>
@endsection

