@extends('layouts.app')

@section('title', 'Pending Approvals')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Pending Approvals</h1>
        <p class="text-muted">Expense transactions awaiting approval</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('transactions.index') }}" class="btn btn-secondary">All Transactions</a>
    </div>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Account</th>
                <th>Category</th>
                <th>Amount</th>
                <th>Reference</th>
                <th>Recorded By</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($transactions as $transaction)
            <tr>
                <td>{{ $transaction->date->format('d M Y') }}</td>
                <td>{{ $transaction->account?->name }}</td>
                <td>{{ $transaction->category?->name }}</td>
                <td class="text-danger">{{ number_format($transaction->amount, 2) }}</td>
                <td>{{ $transaction->reference ?? '-' }}</td>
                <td>{{ $transaction->recorder?->full_name }}</td>
                <td>
                    <div class="action-buttons" style="gap: 0.5rem;">
                        @if(auth()->user()->id !== $transaction->recorded_by && auth()->user()->can('finance.approve'))
                        <form action="{{ route('transactions.approve', $transaction) }}" method="POST" style="display:inline;">
                            @csrf
                            <button type="submit" class="btn btn-sm btn-primary" onclick="return confirm('Approve this expense?')">✅ Approve</button>
                        </form>
                        
                        <button type="button" class="btn btn-sm btn-secondary" onclick="showRejectModal({{ $transaction->id }})">❌ Reject</button>
                        @else
                        <span class="text-muted">Own transaction</span>
                        @endif
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="7" class="empty-state">No pending transactions.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        {{ $transactions->links() }}
    </div>
</div>

<!-- Reject Modal -->
<div id="rejectModal" class="modal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:1000; justify-content:center; align-items:center;">
    <div class="form-card" style="max-width:500px; margin:2rem;">
        <h3 style="margin-bottom:1rem;">Reject Transaction</h3>
        <form id="rejectForm" method="POST">
            @csrf
            <div class="form-group">
                <label for="rejection_reason">Reason for Rejection *</label>
                <textarea id="rejection_reason" name="rejection_reason" rows="3" required placeholder="Explain why this transaction is being rejected..."></textarea>
            </div>
            <div class="form-actions">
                <button type="button" class="btn btn-secondary" onclick="hideRejectModal()">Cancel</button>
                <button type="submit" class="btn btn-primary" style="background: var(--danger);">Reject</button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
function showRejectModal(id) {
    document.getElementById('rejectForm').action = '/transactions/' + id + '/reject';
    document.getElementById('rejectModal').style.display = 'flex';
}
function hideRejectModal() {
    document.getElementById('rejectModal').style.display = 'none';
}
</script>
@endpush
@endsection
