@extends('layouts.app')

@section('title', 'Transaction Details')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Transaction Details</h1>
        <p class="text-muted">Recorded on {{ $transaction->created_at->format('d M Y, H:i') }}</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('transactions.index') }}" class="btn btn-secondary">Back to List</a>
    </div>
</div>

<div class="profile-grid">
    <div class="profile-card">
        <div class="profile-header" style="background: {{ $transaction->type == 'Credit' ? 'linear-gradient(135deg, #059669 0%, #10b981 100%)' : 'linear-gradient(135deg, #dc2626 0%, #ef4444 100%)' }};">
            <div class="profile-avatar">
                {{ $transaction->type == 'Credit' ? '💰' : '💸' }}
            </div>
            <div class="profile-title">
                <h2>{{ $transaction->type == 'Credit' ? 'Income' : 'Expense' }}</h2>
                <span style="color: white; font-size: 1.5rem; font-weight: 700;">
                    {{ number_format($transaction->amount, 2) }} {{ $transaction->account?->currency }}
                </span>
            </div>
        </div>
        
        <div class="profile-details">
            <div class="detail-row">
                <span class="label">Date</span>
                <span class="value">{{ $transaction->date->format('d M Y') }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Account</span>
                <span class="value">{{ $transaction->account?->name }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Category</span>
                <span class="value">{{ $transaction->category?->name }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Reference</span>
                <span class="value">{{ $transaction->reference ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Organization</span>
                <span class="value">{{ $transaction->organization?->name }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Recorded By</span>
                <span class="value">{{ $transaction->recorder?->full_name ?? 'Unknown' }}</span>
            </div>
            @if($transaction->description)
            <div class="detail-row" style="flex-direction: column; align-items: flex-start; gap: 0.5rem;">
                <span class="label">Description</span>
                <span class="value">{{ $transaction->description }}</span>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
