<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name') }} - @yield('title', 'Dashboard')</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/dropdown.css') }}">
    @stack('styles')
</head>
<body>
    @auth
        <nav class="navbar">
            <div class="nav-brand">
                <a href="{{ route('dashboard') }}">{{ config('app.name') }}</a>
            </div>
            <div class="nav-links">
                @foreach(\App\Models\Menu::getForUser() as $menu)
                    @if($menu->activeChildren->isNotEmpty())
                        <div class="nav-dropdown" style="position: relative;">
                            <a href="#" class="dropdown-trigger {{ request()->is(explode('.', $menu->route)[0].'*') ? 'active' : '' }}" onclick="this.nextElementSibling.classList.toggle('show'); return false;">
                                {{ $menu->icon }} {{ $menu->name }} ▼
                            </a>
                            <div class="dropdown-content">
                                @foreach($menu->activeChildren as $child)
                                    <a href="{{ $child->route ? route($child->route) : '#' }}" class="{{ request()->routeIs($child->route) ? 'active' : '' }}">
                                        {{ $child->icon }} {{ $child->name }}
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @else
                        <a href="{{ $menu->route ? route($menu->route) : '#' }}" class="{{ request()->routeIs($menu->route) ? 'active' : '' }}">
                            {{ $menu->icon }} {{ $menu->name }}
                        </a>
                    @endif
                @endforeach
            </div>
            <div class="nav-menu">
                <div class="nav-item">
                    <span class="user-name">{{ auth()->user()->full_name }}</span>
                </div>
                <div class="nav-item">
                    <form action="{{ route('logout') }}" method="POST" style="display: inline;">
                        @csrf
                        <button type="submit" class="btn btn-link">Logout</button>
                    </form>
                </div>
            </div>
        </nav>
    @endauth

    <main class="main-content">
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-error">{{ session('error') }}</div>
        @endif

        @yield('content')
    </main>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Global handler for confirmations
        document.addEventListener('submit', function(e) {
            if (e.target.dataset.confirm) {
                e.preventDefault();
                Swal.fire({
                    title: 'Are you sure?',
                    text: e.target.dataset.confirm,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#4f46e5', // Primary color
                    cancelButtonColor: '#ef4444', // Danger color
                    confirmButtonText: 'Yes, proceed!',
                    background: '#1f2937', // Dark bg
                    color: '#fff'
                }).then((result) => {
                    if (result.isConfirmed) {
                        e.target.submit();
                    }
                });
            }
        });

        // Handler for links with data-confirm
        document.addEventListener('click', function(e) {
            const link = e.target.closest('a[data-confirm], button[data-confirm]');
            if (link) {
                e.preventDefault();
                Swal.fire({
                    title: 'Are you sure?',
                    text: link.dataset.confirm,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#4f46e5',
                    cancelButtonColor: '#ef4444',
                    confirmButtonText: 'Yes, proceed!',
                    background: '#1f2937',
                    color: '#fff'
                }).then((result) => {
                    if (result.isConfirmed) {
                        if (link.tagName === 'BUTTON' && link.type === 'submit') {
                            link.closest('form').submit();
                        } else if (link.tagName === 'A') {
                            window.location.href = link.href;
                        }
                    }
                });
            }
        });
    </script>
    @stack('scripts')
</body>
</html>
