@extends('layouts.app')

@section('title', 'Add Member')

@section('content')
<div class="page-header">
    <h1>Add New Member</h1>
    <p class="text-muted">Register a new member to your organization</p>
</div>

<div class="form-card">
    <form action="{{ route('members.store') }}" method="POST" class="member-form">
        @csrf
        
        <div class="form-row">
            <div class="form-group">
                <label for="first_name">First Name *</label>
                <input type="text" id="first_name" name="first_name" value="{{ old('first_name') }}" required>
                @error('first_name')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="last_name">Last Name *</label>
                <input type="text" id="last_name" name="last_name" value="{{ old('last_name') }}" required>
                @error('last_name')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="text" id="phone" name="phone" value="{{ old('phone') }}">
                @error('phone')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" value="{{ old('email') }}">
                @error('email')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="dob">Date of Birth</label>
                <input type="date" id="dob" name="dob" value="{{ old('dob') }}">
                @error('dob')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="gender">Gender</label>
                <select id="gender" name="gender">
                    <option value="">Select...</option>
                    <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                    <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                </select>
                @error('gender')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="marital_status">Marital Status</label>
                <input type="text" id="marital_status" name="marital_status" value="{{ old('marital_status') }}" placeholder="Single, Married, etc.">
            </div>
            <div class="form-group">
                <label for="profession">Profession</label>
                <input type="text" id="profession" name="profession" value="{{ old('profession') }}" placeholder="Teacher, Engineer, etc.">
            </div>
        </div>
        
        <h3 style="margin: 1.5rem 0 1rem; color: var(--text-secondary); font-size: 0.9rem;">Organization (Select progressively)</h3>
        @include('partials.org-selector')
        
        <div class="form-row" style="margin-top: 1rem;">
            <div class="form-group">
                <label for="category">Category *</label>
                <select id="category" name="category" required>
                    <option value="Professional" {{ old('category') == 'Professional' ? 'selected' : '' }}>Professional</option>
                    <option value="Student" {{ old('category') == 'Student' ? 'selected' : '' }}>Student</option>
                    <option value="Entrepreneur" {{ old('category') == 'Entrepreneur' ? 'selected' : '' }}>Entrepreneur</option>
                    <option value="Other" {{ old('category') == 'Other' ? 'selected' : '' }}>Other</option>
                </select>
                @error('category')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-group">
            <label for="status">Status *</label>
            <select id="status" name="status" required>
                <option value="Active" {{ old('status', 'Active') == 'Active' ? 'selected' : '' }}>Active</option>
                <option value="Inactive" {{ old('status') == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                <option value="Suspended" {{ old('status') == 'Suspended' ? 'selected' : '' }}>Suspended</option>
                <option value="Left" {{ old('status') == 'Left' ? 'selected' : '' }}>Left</option>
            </select>
            @error('status')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-actions">
            <a href="{{ route('members.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Save Member</button>
        </div>
    </form>
</div>
@endsection
