@extends('layouts.app')

@section('title', 'Edit Member')

@section('content')
<div class="page-header">
    <h1>Edit Member</h1>
    <p class="text-muted">Update member information</p>
</div>

<div class="form-card">
    <form action="{{ route('members.update', $member) }}" method="POST" class="member-form">
        @csrf
        @method('PUT')
        
        <div class="form-row">
            <div class="form-group">
                <label for="first_name">First Name *</label>
                <input type="text" id="first_name" name="first_name" value="{{ old('first_name', $member->first_name) }}" required>
                @error('first_name')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="last_name">Last Name *</label>
                <input type="text" id="last_name" name="last_name" value="{{ old('last_name', $member->last_name) }}" required>
                @error('last_name')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="text" id="phone" name="phone" value="{{ old('phone', $member->phone) }}">
                @error('phone')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" value="{{ old('email', $member->email) }}">
                @error('email')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="dob">Date of Birth</label>
                <input type="date" id="dob" name="dob" value="{{ old('dob', $member->dob?->format('Y-m-d')) }}">
                @error('dob')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="gender">Gender</label>
                <select id="gender" name="gender">
                    <option value="">Select...</option>
                    <option value="Male" {{ old('gender', $member->gender) == 'Male' ? 'selected' : '' }}>Male</option>
                    <option value="Female" {{ old('gender', $member->gender) == 'Female' ? 'selected' : '' }}>Female</option>
                </select>
                @error('gender')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="marital_status">Marital Status</label>
                <input type="text" id="marital_status" name="marital_status" value="{{ old('marital_status', $member->marital_status) }}">
            </div>
            <div class="form-group">
                <label for="profession">Profession</label>
                <input type="text" id="profession" name="profession" value="{{ old('profession', $member->profession) }}">
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="organization_id">Organization *</label>
                <select id="organization_id" name="organization_id" required>
                    <option value="">Select Organization...</option>
                    @foreach($organizations as $org)
                    <option value="{{ $org->id }}" {{ old('organization_id', $member->organization_id) == $org->id ? 'selected' : '' }}>{{ $org->name }}</option>
                    @endforeach
                </select>
                @error('organization_id')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="category">Category *</label>
                <select id="category" name="category" required>
                    <option value="Professional" {{ old('category', $member->category) == 'Professional' ? 'selected' : '' }}>Professional</option>
                    <option value="Student" {{ old('category', $member->category) == 'Student' ? 'selected' : '' }}>Student</option>
                    <option value="Entrepreneur" {{ old('category', $member->category) == 'Entrepreneur' ? 'selected' : '' }}>Entrepreneur</option>
                    <option value="Other" {{ old('category', $member->category) == 'Other' ? 'selected' : '' }}>Other</option>
                </select>
                @error('category')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-group">
            <label for="status">Status *</label>
            <select id="status" name="status" required>
                <option value="Active" {{ old('status', $member->status) == 'Active' ? 'selected' : '' }}>Active</option>
                <option value="Inactive" {{ old('status', $member->status) == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                <option value="Suspended" {{ old('status', $member->status) == 'Suspended' ? 'selected' : '' }}>Suspended</option>
                <option value="Left" {{ old('status', $member->status) == 'Left' ? 'selected' : '' }}>Left</option>
            </select>
            @error('status')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-actions">
            <a href="{{ route('members.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Update Member</button>
        </div>
    </form>
</div>
@endsection
