@extends('layouts.app')

@section('title', 'Members')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Members</h1>
        <p class="text-muted">Manage your organization's members</p>
    </div>
    <div class="header-actions">
        @can('members.export')
        <a href="{{ route('members.export', request()->query()) }}" class="btn btn-secondary">Export CSV</a>
        @endcan
        @can('members.create')
        <a href="{{ route('members.create') }}" class="btn btn-primary">+ Add Member</a>
        @endcan
    </div>
</div>

<!-- Filters -->
<div class="filters-card">
    <form action="{{ route('members.index') }}" method="GET" class="filters-form">
        <div class="filter-group">
            <input type="text" name="search" placeholder="Search name, email, phone..." value="{{ request('search') }}">
        </div>
        <div class="filter-group">
            <select name="status">
                <option value="">All Status</option>
                <option value="Active" {{ request('status') == 'Active' ? 'selected' : '' }}>Active</option>
                <option value="Inactive" {{ request('status') == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                <option value="Suspended" {{ request('status') == 'Suspended' ? 'selected' : '' }}>Suspended</option>
                <option value="Left" {{ request('status') == 'Left' ? 'selected' : '' }}>Left</option>
            </select>
        </div>
        <div class="filter-group">
            <select name="category">
                <option value="">All Categories</option>
                <option value="Professional" {{ request('category') == 'Professional' ? 'selected' : '' }}>Professional</option>
                <option value="Student" {{ request('category') == 'Student' ? 'selected' : '' }}>Student</option>
                <option value="Entrepreneur" {{ request('category') == 'Entrepreneur' ? 'selected' : '' }}>Entrepreneur</option>
                <option value="Other" {{ request('category') == 'Other' ? 'selected' : '' }}>Other</option>
            </select>
        </div>
        <div class="filter-group">
            <select name="organization_id">
                <option value="">All Organizations</option>
                @foreach($organizations as $org)
                <option value="{{ $org->id }}" {{ request('organization_id') == $org->id ? 'selected' : '' }}>{{ $org->name }}</option>
                @endforeach
            </select>
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
        <a href="{{ route('members.index') }}" class="btn btn-link">Clear</a>
    </form>
</div>

<!-- Members Table -->
<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Contact</th>
                <th>Organization</th>
                <th>Category</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($members as $member)
            <tr>
                <td>
                    <a href="{{ route('members.show', $member) }}" class="member-name">
                        {{ $member->full_name }}
                    </a>
                </td>
                <td>
                    <div class="contact-info">
                        @if($member->phone)<span>📱 {{ $member->phone }}</span>@endif
                        @if($member->email)<span>✉️ {{ $member->email }}</span>@endif
                    </div>
                </td>
                <td>{{ $member->organization?->name }}</td>
                <td><span class="badge badge-info">{{ $member->category }}</span></td>
                <td>
                    <span class="badge badge-{{ $member->status == 'Active' ? 'success' : ($member->status == 'Suspended' ? 'danger' : 'warning') }}">
                        {{ $member->status }}
                    </span>
                </td>
                <td>
                    <div class="action-buttons">
                        <a href="{{ route('members.show', $member) }}" class="btn btn-sm btn-link" title="View">👁️</a>
                        @can('members.edit')
                        <a href="{{ route('members.edit', $member) }}" class="btn btn-sm btn-link" title="Edit">✏️</a>
                        @endcan
                        @can('members.delete')
                        <form action="{{ route('members.destroy', $member) }}" method="POST" style="display:inline;" data-confirm="Are you sure you want to delete this member?">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-link" title="Delete">🗑️</button>
                        </form>
                        @endcan
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="6" class="empty-state">No members found.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        {{ $members->links() }}
    </div>
</div>
@endsection
