@extends('layouts.app')

@section('title', $member->full_name)

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>{{ $member->full_name }}</h1>
        <p class="text-muted">Member Profile</p>
    </div>
    <div class="header-actions">
        @can('members.edit')
        <a href="{{ route('members.edit', $member) }}" class="btn btn-primary">Edit</a>
        @endcan
        <a href="{{ route('members.index') }}" class="btn btn-secondary">Back to List</a>
    </div>
</div>

<div class="profile-grid">
    <div class="profile-card">
        <div class="profile-header">
            <div class="profile-avatar">
                {{ strtoupper(substr($member->first_name, 0, 1) . substr($member->last_name, 0, 1)) }}
            </div>
            <div class="profile-title">
                <h2>{{ $member->full_name }}</h2>
                <span class="badge badge-{{ $member->status == 'Active' ? 'success' : 'warning' }}">{{ $member->status }}</span>
            </div>
        </div>
        
        <div class="profile-details">
            <div class="detail-row">
                <span class="label">Organization</span>
                <span class="value">{{ $member->organization?->name ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Category</span>
                <span class="value">{{ $member->category }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Phone</span>
                <span class="value">{{ $member->phone ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Email</span>
                <span class="value">{{ $member->email ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Date of Birth</span>
                <span class="value">{{ $member->dob?->format('d M Y') ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Gender</span>
                <span class="value">{{ $member->gender ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Marital Status</span>
                <span class="value">{{ $member->marital_status ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Profession</span>
                <span class="value">{{ $member->profession ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Registered</span>
                <span class="value">{{ $member->created_at->format('d M Y') }}</span>
            </div>
        </div>
    </div>
    
    <div class="profile-sidebar">
        <div class="sidebar-card">
            <h3>Quick Stats</h3>
            <div class="stat-item">
                <span class="stat-label">Contributions</span>
                <span class="stat-value">0</span>
            </div>
            <div class="stat-item">
                <span class="stat-label">Pledges</span>
                <span class="stat-value">0</span>
            </div>
            <div class="stat-item">
                <span class="stat-label">Events Attended</span>
                <span class="stat-value">0</span>
            </div>
        </div>
    </div>
</div>
@endsection
