@extends('layouts.app')

@section('title', 'Add Organization')

@section('content')
<div class="page-header">
    <h1>Add Organization</h1>
    <p class="text-muted">Create a new organizational unit</p>
</div>

<div class="form-card">
    <form action="{{ route('organizations.store') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="name">Organization Name *</label>
            <input type="text" id="name" name="name" value="{{ old('name') }}" required placeholder="e.g., East Zone, Dar es Salaam Jimbo">
            @error('name')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="level_id">Level *</label>
                <select id="level_id" name="level_id" required>
                    <option value="">Select Level...</option>
                    @foreach($levels as $level)
                    <option value="{{ $level->id }}" {{ old('level_id') == $level->id ? 'selected' : '' }}>{{ $level->name }}</option>
                    @endforeach
                </select>
                @error('level_id')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="parent_id">Parent Organization</label>
                <select id="parent_id" name="parent_id">
                    <option value="">None (Top Level)</option>
                    @foreach($parentOrgs as $org)
                    <option value="{{ $org->id }}" {{ old('parent_id', request('parent_id')) == $org->id ? 'selected' : '' }}>
                        {{ $org->name }} ({{ $org->level?->name }})
                    </option>
                    @endforeach
                </select>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="code">Organization Code</label>
                <input type="text" id="code" name="code" value="{{ old('code') }}" placeholder="e.g., ATAPE-EAST">
                @error('code')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="location">Location</label>
                <input type="text" id="location" name="location" value="{{ old('location') }}" placeholder="e.g., Dar es Salaam Region">
            </div>
        </div>
        
        <div class="form-actions">
            <a href="{{ route('organizations.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Create Organization</button>
        </div>
    </form>
</div>
@endsection
