@extends('layouts.app')

@section('title', 'Edit Organization')

@section('content')
<div class="page-header">
    <h1>Edit Organization</h1>
    <p class="text-muted">{{ $organization->name }}</p>
</div>

<div class="form-card">
    <form action="{{ route('organizations.update', $organization) }}" method="POST">
        @csrf
        @method('PUT')
        
        <div class="form-group">
            <label for="name">Organization Name *</label>
            <input type="text" id="name" name="name" value="{{ old('name', $organization->name) }}" required>
            @error('name')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="level_id">Level *</label>
                <select id="level_id" name="level_id" required>
                    @foreach($levels as $level)
                    <option value="{{ $level->id }}" {{ old('level_id', $organization->level_id) == $level->id ? 'selected' : '' }}>{{ $level->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label for="parent_id">Parent Organization</label>
                <select id="parent_id" name="parent_id">
                    <option value="">None (Top Level)</option>
                    @foreach($parentOrgs as $org)
                    <option value="{{ $org->id }}" {{ old('parent_id', $organization->parent_id) == $org->id ? 'selected' : '' }}>
                        {{ $org->name }} ({{ $org->level?->name }})
                    </option>
                    @endforeach
                </select>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="code">Organization Code</label>
                <input type="text" id="code" name="code" value="{{ old('code', $organization->code) }}">
            </div>
            <div class="form-group">
                <label for="location">Location</label>
                <input type="text" id="location" name="location" value="{{ old('location', $organization->location) }}">
            </div>
        </div>
        
        <div class="form-actions">
            <a href="{{ route('organizations.show', $organization) }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Save Changes</button>
        </div>
    </form>
</div>

<!-- Danger Zone -->
<div class="form-card" style="margin-top: 2rem; border-color: var(--danger);">
    <h3 style="color: var(--danger);">⚠️ Danger Zone</h3>
    <p class="text-muted">Delete this organization. This cannot be undone.</p>
    <form action="{{ route('organizations.destroy', $organization) }}" method="POST">
        @csrf
        @method('DELETE')
        <button type="submit" class="btn btn-secondary" style="background: var(--danger);" onclick="return confirm('Are you sure? This cannot be undone.')">
            Delete Organization
        </button>
    </form>
</div>
@endsection
