@extends('layouts.app')

@section('title', 'Organizations')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Organizations</h1>
        <p class="text-muted">Manage organizational hierarchy</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('organizations.create') }}" class="btn btn-primary">+ Add Organization</a>
    </div>
</div>

<!-- Level Legend -->
<div class="stats-grid" style="margin-bottom: 2rem;">
    @foreach($levels as $level)
    <div class="stat-card" style="padding: 0.75rem 1rem; text-align: center;">
        <span class="badge badge-{{ $level->slug }}">
            {{ $level->name }}
        </span>
    </div>
    @endforeach
</div>

<!-- Organization Tree -->
<div class="table-card">
    @foreach($organizations as $org)
        @include('organizations.partials.tree-node', ['org' => $org, 'depth' => 0])
    @endforeach
    
    @if($organizations->isEmpty())
        <div class="empty-state" style="padding: 2rem; text-align: center;">
            No organizations found. <a href="{{ route('organizations.create') }}">Create one</a>.
        </div>
    @endif
</div>
@endsection
