<div class="org-tree-node level-{{ $org->level?->slug }}" style="margin-left: {{ $depth * 1.5 }}rem; padding: 0.75rem; border-radius: 0 8px 8px 0;">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <div>
            <a href="{{ route('organizations.show', $org) }}" style="font-weight: 600; font-size: 1rem;">
                {{ $org->name }}
            </a>
            <span class="badge badge-{{ $org->level?->slug }}" style="margin-left: 0.5rem;">
                {{ $org->level?->name }}
            </span>
            @if($org->code)
            <span class="text-muted" style="margin-left: 0.5rem; font-size: 0.8rem;">{{ $org->code }}</span>
            @endif
        </div>
        <div style="display: flex; gap: 1rem; align-items: center; font-size: 0.85rem;">
            <span title="Direct Members">👥 {{ $org->direct_member_count }}</span>
            <span title="Child Organizations">📁 {{ $org->children->count() }}</span>
            <a href="{{ route('organizations.edit', $org) }}" class="btn btn-sm btn-link">✏️</a>
        </div>
    </div>
</div>

@if($org->children->count() > 0 && $depth < 4)
    @foreach($org->children as $child)
        @include('organizations.partials.tree-node', ['org' => $child, 'depth' => $depth + 1])
    @endforeach
@endif

