@extends('layouts.app')

@section('title', $organization->name)

@section('content')
<div class="page-header">
    <div class="header-left">
        <!-- Breadcrumb -->
        <nav style="font-size: 0.85rem; margin-bottom: 0.5rem;">
            @foreach($organization->breadcrumb as $ancestor)
                @if(!$loop->last)
                    <a href="{{ route('organizations.show', $ancestor) }}">{{ $ancestor->name }}</a>
                    <span style="margin: 0 0.5rem;">›</span>
                @else
                    <span>{{ $ancestor->name }}</span>
                @endif
            @endforeach
        </nav>
        <h1>{{ $organization->name }}</h1>
        <p class="text-muted">
            <span class="badge badge-{{ $organization->level?->slug == 'national' ? 'primary' : ($organization->level?->slug == 'zonal' ? 'success' : ($organization->level?->slug == 'jimbo' ? 'warning' : 'info')) }}">
                {{ $organization->level?->name }}
            </span>
            @if($organization->code)
            <span style="margin-left: 0.5rem;">{{ $organization->code }}</span>
            @endif
            @if($organization->location)
            <span style="margin-left: 0.5rem;">📍 {{ $organization->location }}</span>
            @endif
        </p>
    </div>
    <div class="header-actions">
        <a href="{{ route('organizations.edit', $organization) }}" class="btn btn-secondary">✏️ Edit</a>
        <a href="{{ route('organizations.create', ['parent_id' => $organization->id]) }}" class="btn btn-primary">+ Add Sub-Organization</a>
    </div>
</div>

<!-- Statistics -->
<div class="stats-grid" style="margin-bottom: 2rem;">
    <div class="stat-card">
        <div class="stat-value">{{ $organization->direct_member_count }}</div>
        <div class="stat-label">Direct Members</div>
    </div>
    <div class="stat-card">
        <div class="stat-value">{{ $organization->total_member_count }}</div>
        <div class="stat-label">Total Members (incl. sub-orgs)</div>
    </div>
    <div class="stat-card">
        <div class="stat-value">{{ $organization->children->count() }}</div>
        <div class="stat-label">Sub-Organizations</div>
    </div>
    <div class="stat-card">
        <div class="stat-value">{{ number_format($organization->total_contributions, 0) }}</div>
        <div class="stat-label">Total Contributions (TZS)</div>
    </div>
</div>

<div class="profile-grid">
    <!-- Leadership Board -->
    <div class="sidebar-card">
        <h3>👔 Leadership Board</h3>
        @forelse($organization->currentLeaders as $leader)
        <div class="stat-item" style="display: flex; justify-content: space-between; align-items: center;">
            <div>
                <strong>{{ $leader->position }}</strong><br>
                <small>{{ $leader->leader_name }}</small>
            </div>
            <form action="{{ route('organizations.leaders.destroy', [$organization, $leader]) }}" method="POST">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-sm btn-link" onclick="return confirm('Remove leader?')">🗑️</button>
            </form>
        </div>
        @empty
        <p class="text-muted">No leaders assigned.</p>
        @endforelse

        <!-- Add Leader Form -->
        <form action="{{ route('organizations.leaders.store', $organization) }}" method="POST" style="margin-top: 1rem; padding-top: 1rem; border-top: 1px solid var(--border);">
            @csrf
            <div class="form-group" style="margin-bottom: 0.5rem;">
                <select name="member_id" required style="font-size: 0.85rem;">
                    <option value="">Select Member...</option>
                    @foreach($members as $member)
                    <option value="{{ $member->id }}">{{ $member->full_name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group" style="margin-bottom: 0.5rem;">
                <select name="position" required style="font-size: 0.85rem;">
                    <option value="">Select Position...</option>
                    @foreach($positions as $pos)
                    <option value="{{ $pos }}">{{ $pos }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group" style="margin-bottom: 0.5rem;">
                <input type="date" name="started_at" value="{{ date('Y-m-d') }}" required style="font-size: 0.85rem;">
            </div>
            <button type="submit" class="btn btn-sm btn-primary">Add Leader</button>
        </form>
    </div>

    <!-- Sub-Organizations -->
    <div class="sidebar-card">
        <h3>📁 Sub-Organizations</h3>
        @forelse($organization->children as $child)
        <div class="stat-item">
            <a href="{{ route('organizations.show', $child) }}">{{ $child->name }}</a>
            <span class="badge badge-{{ $child->level?->slug == 'zonal' ? 'success' : ($child->level?->slug == 'jimbo' ? 'warning' : 'info') }}" style="margin-left: 0.5rem; font-size: 0.7rem;">
                {{ $child->level?->name }}
            </span>
        </div>
        @empty
        <p class="text-muted">No sub-organizations.</p>
        @endforelse
    </div>
</div>

<!-- Members List -->
@if($organization->members->count() > 0)
<div class="table-card" style="margin-top: 2rem;">
    <h3 style="padding: 1rem 1.5rem; border-bottom: 1px solid var(--border); margin: 0;">👥 Direct Members</h3>
    <table class="data-table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Phone</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($organization->members->take(10) as $member)
            <tr>
                <td><a href="{{ route('members.show', $member) }}">{{ $member->full_name }}</a></td>
                <td>{{ $member->phone ?? '-' }}</td>
                <td><span class="badge badge-{{ $member->status == 'Active' ? 'success' : 'secondary' }}">{{ $member->status }}</span></td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @if($organization->members->count() > 10)
    <div style="padding: 1rem; text-align: center;">
        <a href="{{ route('members.index', ['organization_id' => $organization->id]) }}">View all {{ $organization->members->count() }} members →</a>
    </div>
    @endif
</div>
@endif
@endsection
