{{-- Cascading Organization Selector --}}
{{-- Include this partial in forms that need to select organization by hierarchy --}}
{{-- Requires: $organizations (for initial load, optional) --}}

<div class="cascading-select-group" id="orgSelector">
    <div class="cascading-select-row">
        <div class="form-group">
            <label for="org_union">Union</label>
            <select id="org_union" name="org_union" onchange="loadChildren(this, 'org_conference', 'conference')">
                <option value="">Select Union...</option>
                @foreach(\App\Models\Organization::whereHas('level', fn($q) => $q->where('slug', 'union'))->orderBy('name')->get() as $union)
                <option value="{{ $union->id }}" {{ old('org_union', request('org_union')) == $union->id ? 'selected' : '' }}>{{ $union->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <label for="org_conference">Conference</label>
            <select id="org_conference" name="org_conference" onchange="loadChildren(this, 'org_zone', 'zone')" disabled>
                <option value="">Select Conference...</option>
            </select>
        </div>
    </div>
    <div class="cascading-select-row">
        <div class="form-group">
            <label for="org_zone">Zone</label>
            <select id="org_zone" name="org_zone" onchange="loadChildren(this, 'organization_id', 'local')" disabled>
                <option value="">Select Zone...</option>
            </select>
        </div>
        <div class="form-group">
            <label for="organization_id">Local Church *</label>
            <select id="organization_id" name="organization_id" disabled required>
                <option value="">Select Local Church...</option>
            </select>
            @error('organization_id')<span class="error-text">{{ $message }}</span>@enderror
        </div>
    </div>
</div>

@push('scripts')
<script>
async function loadChildren(selectElement, targetId, levelSlug) {
    const parentId = selectElement.value;
    const targetSelect = document.getElementById(targetId);
    
    // Reset all downstream selects
    resetDownstream(targetId);
    
    if (!parentId) {
        targetSelect.disabled = true;
        return;
    }
    
    try {
        const response = await fetch(`/organizations/${parentId}/children`);
        const children = await response.json();
        
        targetSelect.innerHTML = '<option value="">Select...</option>';
        children.forEach(child => {
            const option = document.createElement('option');
            option.value = child.id;
            option.textContent = child.name;
            targetSelect.appendChild(option);
        });
        
        targetSelect.disabled = false;
    } catch (error) {
        console.error('Failed to load organizations:', error);
    }
}

function resetDownstream(startId) {
    const selects = ['org_conference', 'org_zone', 'organization_id'];
    let reset = false;
    
    selects.forEach(id => {
        if (id === startId || reset) {
            reset = true;
            const select = document.getElementById(id);
            if (select) {
                select.innerHTML = '<option value="">Select...</option>';
                select.disabled = true;
            }
        }
    });
}
</script>
@endpush
