@extends('layouts.app')

@section('title', 'Record Contribution')

@section('content')
<div class="page-header">
    <h1>Record Contribution</h1>
    <p class="text-muted">Record a member payment or contribution</p>
</div>

<div class="form-card">
    <form action="{{ route('contributions.store') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="member_id">Member *</label>
            <select id="member_id" name="member_id" required onchange="loadPledges()">
                <option value="">Select Member...</option>
                @foreach($members as $member)
                <option value="{{ $member->id }}" {{ old('member_id', request('member_id')) == $member->id ? 'selected' : '' }}>
                    {{ $member->full_name }} ({{ $member->organization?->name }})
                </option>
                @endforeach
            </select>
            @error('member_id')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        @if($pledges->count() > 0)
        <div class="form-group">
            <label for="pledge_id">Apply to Pledge (Optional)</label>
            <select id="pledge_id" name="pledge_id">
                <option value="">No pledge - General contribution</option>
                @foreach($pledges as $pledge)
                <option value="{{ $pledge->id }}" {{ old('pledge_id', request('pledge_id')) == $pledge->id ? 'selected' : '' }}>
                    {{ $pledge->purpose }} ({{ $pledge->year }}) - Remaining: {{ number_format($pledge->remaining, 2) }}
                </option>
                @endforeach
            </select>
        </div>
        @endif
        
        <div class="form-row">
            <div class="form-group">
                <label for="amount">Amount *</label>
                <div class="currency-input">
                    <input type="number" id="amount" name="amount" value="{{ old('amount') }}" step="0.01" min="1" required placeholder="0.00">
                </div>
                @error('amount')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="date">Date *</label>
                <input type="date" id="date" name="date" value="{{ old('date', date('Y-m-d')) }}" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="purpose">Purpose *</label>
            <input type="text" id="purpose" name="purpose" value="{{ old('purpose') }}" required placeholder="e.g., Monthly Tithe, Building Fund">
            @error('purpose')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="account_id">Receive into Account *</label>
                <select id="account_id" name="account_id" required>
                    <option value="">Select Account...</option>
                    @foreach($accounts as $account)
                    <option value="{{ $account->id }}" {{ old('account_id') == $account->id ? 'selected' : '' }}>
                        {{ $account->name }} ({{ $account->currency }})
                    </option>
                    @endforeach
                </select>
                @error('account_id')<span class="error-text">{{ $message }}</span>@enderror
            </div>
            <div class="form-group">
                <label for="category_id">Category *</label>
                <select id="category_id" name="category_id" required>
                    <option value="">Select Category...</option>
                    @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                        {{ $category->name }}
                    </option>
                    @endforeach
                </select>
            </div>
        </div>
        
        <div class="form-group">
            <label for="reference">Reference Number</label>
            <input type="text" id="reference" name="reference" value="{{ old('reference') }}" placeholder="e.g., Receipt #12345">
        </div>
        
        <div class="form-actions">
            <a href="{{ route('contributions.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Record Contribution</button>
        </div>
    </form>
</div>

@push('scripts')
<script>
function loadPledges() {
    const memberId = document.getElementById('member_id').value;
    if (memberId) {
        window.location.href = '{{ route('contributions.create') }}?member_id=' + memberId;
    }
}
</script>
@endpush
@endsection
