@extends('layouts.app')

@section('title', 'Contributions')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Contributions</h1>
        <p class="text-muted">Member payments and contributions</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('contributions.create') }}" class="btn btn-primary">+ Record Contribution</a>
    </div>
</div>

<div class="filters-card">
    <form action="{{ route('contributions.index') }}" method="GET" class="filters-form">
        <div class="filter-group">
            <input type="text" name="search" placeholder="Search member..." value="{{ request('search') }}">
        </div>
        <div class="filter-group">
            <input type="date" name="date_from" value="{{ request('date_from') }}">
        </div>
        <div class="filter-group">
            <input type="date" name="date_to" value="{{ request('date_to') }}">
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
    </form>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Member</th>
                <th>Purpose</th>
                <th>Amount</th>
                <th>Pledge</th>
                <th>Account</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($contributions as $contribution)
            <tr>
                <td>{{ $contribution->date->format('d M Y') }}</td>
                <td><strong>{{ $contribution->member?->full_name }}</strong></td>
                <td>{{ $contribution->purpose }}</td>
                <td class="text-success">+{{ number_format($contribution->amount, 2) }}</td>
                <td>
                    @if($contribution->pledge)
                        <a href="{{ route('pledges.show', $contribution->pledge) }}">{{ $contribution->pledge->purpose }}</a>
                    @else
                        <span class="text-muted">-</span>
                    @endif
                </td>
                <td>{{ $contribution->transaction?->account?->name }}</td>
                <td>
                    <a href="{{ route('contributions.show', $contribution) }}" class="btn btn-sm btn-link">👁️</a>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="7" class="empty-state">No contributions found.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        {{ $contributions->links() }}
    </div>
</div>
@endsection
