@extends('layouts.app')

@section('title', 'Contribution Details')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Contribution Details</h1>
        <p class="text-muted">Recorded on {{ $contribution->created_at->format('d M Y, H:i') }}</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('contributions.index') }}" class="btn btn-secondary">Back to List</a>
    </div>
</div>

<div class="profile-grid">
    <div class="profile-card">
        <div class="profile-header" style="background: linear-gradient(135deg, #059669 0%, #10b981 100%);">
            <div class="profile-avatar">💰</div>
            <div class="profile-title">
                <h2>{{ $contribution->member?->full_name }}</h2>
                <span style="color: white; font-size: 1.5rem; font-weight: 700;">
                    TZS {{ number_format($contribution->amount, 2) }}
                </span>
            </div>
        </div>
        
        <div class="profile-details">
            <div class="detail-row">
                <span class="label">Date</span>
                <span class="value">{{ $contribution->date->format('d M Y') }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Purpose</span>
                <span class="value">{{ $contribution->purpose }}</span>
            </div>
            @if($contribution->pledge)
            <div class="detail-row">
                <span class="label">Applied to Pledge</span>
                <span class="value">
                    <a href="{{ route('pledges.show', $contribution->pledge) }}">
                        {{ $contribution->pledge->purpose }} ({{ $contribution->pledge->year }})
                    </a>
                </span>
            </div>
            @endif
            <div class="detail-row">
                <span class="label">Account</span>
                <span class="value">{{ $contribution->transaction?->account?->name }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Reference</span>
                <span class="value">{{ $contribution->transaction?->reference ?? '-' }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Organization</span>
                <span class="value">{{ $contribution->member?->organization?->name }}</span>
            </div>
        </div>
    </div>
</div>
@endsection
