@extends('layouts.app')

@section('title', 'Add Pledge')

@section('content')
<div class="page-header">
    <h1>Add New Pledge</h1>
    <p class="text-muted">Create a new member commitment</p>
</div>

<div class="form-card">
    <form action="{{ route('pledges.store') }}" method="POST">
        @csrf
        
        <div class="form-group">
            <label for="member_id">Member *</label>
            <select id="member_id" name="member_id" required>
                <option value="">Select Member...</option>
                @foreach($members as $member)
                <option value="{{ $member->id }}" {{ old('member_id') == $member->id ? 'selected' : '' }}>
                    {{ $member->full_name }} ({{ $member->organization?->name }})
                </option>
                @endforeach
            </select>
            @error('member_id')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="year">Year *</label>
                <select id="year" name="year" required>
                    @for($y = date('Y') + 1; $y >= 2020; $y--)
                    <option value="{{ $y }}" {{ old('year', date('Y')) == $y ? 'selected' : '' }}>{{ $y }}</option>
                    @endfor
                </select>
            </div>
            <div class="form-group">
                <label for="amount">Amount *</label>
                <div class="currency-input">
                    <input type="number" id="amount" name="amount" value="{{ old('amount') }}" step="0.01" min="1" required placeholder="0.00">
                </div>
                @error('amount')<span class="error-text">{{ $message }}</span>@enderror
            </div>
        </div>
        
        <div class="form-group">
            <label for="purpose">Purpose *</label>
            <input type="text" id="purpose" name="purpose" value="{{ old('purpose') }}" required placeholder="e.g., Annual Membership Fee, Building Project">
            @error('purpose')<span class="error-text">{{ $message }}</span>@enderror
        </div>
        
        <div class="form-actions">
            <a href="{{ route('pledges.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Create Pledge</button>
        </div>
    </form>
</div>
@endsection
