@extends('layouts.app')

@section('title', 'Edit Pledge')

@section('content')
<div class="page-header">
    <h1>Edit Pledge</h1>
    <p class="text-muted">Update pledge details</p>
</div>

<div class="form-card">
    <form action="{{ route('pledges.update', $pledge) }}" method="POST">
        @csrf
        @method('PUT')
        
        <div class="form-group">
            <label>Member</label>
            <input type="text" value="{{ $pledge->member?->full_name }}" disabled>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="year">Year *</label>
                <select id="year" name="year" required>
                    @for($y = date('Y') + 1; $y >= 2020; $y--)
                    <option value="{{ $y }}" {{ old('year', $pledge->year) == $y ? 'selected' : '' }}>{{ $y }}</option>
                    @endfor
                </select>
            </div>
            <div class="form-group">
                <label for="amount">Amount (TZS) *</label>
                <input type="number" id="amount" name="amount" value="{{ old('amount', $pledge->amount) }}" step="0.01" min="1" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="purpose">Purpose *</label>
            <input type="text" id="purpose" name="purpose" value="{{ old('purpose', $pledge->purpose) }}" required>
        </div>
        
        <div class="alert alert-info" style="margin-top: 1rem;">
            <strong>Already Paid:</strong> TZS {{ number_format($pledge->paid_amount, 2) }}
        </div>
        
        <div class="form-actions">
            <a href="{{ route('pledges.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Update Pledge</button>
        </div>
    </form>
</div>
@endsection
