@extends('layouts.app')

@section('title', 'Pledges')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Pledges (Ahadi)</h1>
        <p class="text-muted">Manage member commitments and pledges</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('pledges.create') }}" class="btn btn-primary">+ Add Pledge</a>
    </div>
</div>

<div class="filters-card">
    <form action="{{ route('pledges.index') }}" method="GET" class="filters-form">
        <div class="filter-group">
            <input type="text" name="search" placeholder="Search member..." value="{{ request('search') }}">
        </div>
        <div class="filter-group">
            <select name="year">
                <option value="">All Years</option>
                @for($y = date('Y'); $y >= 2020; $y--)
                <option value="{{ $y }}" {{ request('year') == $y ? 'selected' : '' }}>{{ $y }}</option>
                @endfor
            </select>
        </div>
        <div class="filter-group">
            <select name="status">
                <option value="">All Statuses</option>
                <option value="Pending" {{ request('status') == 'Pending' ? 'selected' : '' }}>Pending</option>
                <option value="Partial" {{ request('status') == 'Partial' ? 'selected' : '' }}>Partial</option>
                <option value="Completed" {{ request('status') == 'Completed' ? 'selected' : '' }}>Completed</option>
            </select>
        </div>
        <button type="submit" class="btn btn-secondary">Filter</button>
    </form>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Member</th>
                <th>Year</th>
                <th>Purpose</th>
                <th>Amount</th>
                <th>Paid</th>
                <th>Progress</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($pledges as $pledge)
            <tr>
                <td><strong>{{ $pledge->member?->full_name }}</strong></td>
                <td>{{ $pledge->year }}</td>
                <td>{{ $pledge->purpose }}</td>
                <td>{{ number_format($pledge->amount, 2) }}</td>
                <td>{{ number_format($pledge->paid_amount, 2) }}</td>
                <td>
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: {{ $pledge->progress }}%; background: {{ $pledge->status == 'Completed' ? 'var(--success)' : 'var(--primary)' }};"></div>
                    </div>
                    <small>{{ $pledge->progress }}%</small>
                </td>
                <td>
                    @if($pledge->status === 'Pending')
                        <span class="badge badge-warning">Pending</span>
                    @elseif($pledge->status === 'Partial')
                        <span class="badge badge-info">Partial</span>
                    @else
                        <span class="badge badge-success">Completed</span>
                    @endif
                </td>
                <td>
                    <div class="action-buttons">
                        <a href="{{ route('pledges.show', $pledge) }}" class="btn btn-sm btn-link">👁️</a>
                        <a href="{{ route('pledges.edit', $pledge) }}" class="btn btn-sm btn-link">✏️</a>
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="8" class="empty-state">No pledges found.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        {{ $pledges->links() }}
    </div>
</div>

@push('styles')
<style>
.progress-bar {
    width: 100px;
    height: 8px;
    background: var(--bg-light);
    border-radius: 4px;
    overflow: hidden;
}
.progress-fill {
    height: 100%;
    transition: width 0.3s ease;
}
</style>
@endpush
@endsection
