@extends('layouts.app')

@section('title', 'Pledge Details')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Pledge Details</h1>
        <p class="text-muted">{{ $pledge->purpose }} - {{ $pledge->year }}</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('contributions.create', ['member_id' => $pledge->member_id, 'pledge_id' => $pledge->id]) }}" class="btn btn-primary">+ Make Payment</a>
        <a href="{{ route('pledges.edit', $pledge) }}" class="btn btn-secondary">Edit</a>
    </div>
</div>

<div class="profile-grid">
    <div class="profile-card">
        <div class="profile-header">
            <div class="profile-avatar">📋</div>
            <div class="profile-title">
                <h2>{{ $pledge->member?->full_name }}</h2>
                <span style="color: white;">{{ $pledge->member?->organization?->name }}</span>
            </div>
        </div>
        
        <div class="profile-details">
            <div class="detail-row">
                <span class="label">Year</span>
                <span class="value">{{ $pledge->year }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Purpose</span>
                <span class="value">{{ $pledge->purpose }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Pledged Amount</span>
                <span class="value">TZS {{ number_format($pledge->amount, 2) }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Paid Amount</span>
                <span class="value text-success">TZS {{ number_format($pledge->paid_amount, 2) }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Remaining</span>
                <span class="value text-danger">TZS {{ number_format($pledge->remaining, 2) }}</span>
            </div>
            <div class="detail-row">
                <span class="label">Progress</span>
                <span class="value">{{ $pledge->progress }}%</span>
            </div>
            <div class="detail-row">
                <span class="label">Status</span>
                <span class="value">
                    @if($pledge->status === 'Pending')
                        <span class="badge badge-warning">Pending</span>
                    @elseif($pledge->status === 'Partial')
                        <span class="badge badge-info">Partial</span>
                    @else
                        <span class="badge badge-success">Completed</span>
                    @endif
                </span>
            </div>
        </div>
    </div>
    
    <div class="sidebar-card">
        <h3>Payment History</h3>
        @forelse($pledge->contributions as $contribution)
        <div class="stat-item">
            <span class="stat-label">{{ $contribution->date->format('d M Y') }}</span>
            <span class="stat-value text-success">+{{ number_format($contribution->amount, 2) }}</span>
        </div>
        @empty
        <p class="text-muted">No payments yet.</p>
        @endforelse
    </div>
</div>
@endsection
