@extends('layouts.app')

@section('title', 'Create Role')

@section('content')
<div class="page-header">
    <div class="header-left">
        <h1>Create Role</h1>
        <p class="text-muted">Define a new role and assign permissions</p>
    </div>
    <div class="header-actions">
        <a href="{{ route('settings.index', ['tab' => 'roles']) }}" class="btn btn-secondary">Cancel</a>
    </div>
</div>

<form action="{{ route('roles.store') }}" method="POST">
    @csrf
    
    <div class="card" style="margin-bottom: 2rem;">
        <div class="form-group">
            <label for="name">Role Name *</label>
            <input type="text" id="name" name="name" class="form-control" required placeholder="e.g. Treasurer" style="max-width: 400px;">
        </div>
    </div>

    <div class="card">
        <h3>Permissions</h3>
        <p class="text-muted" style="margin-bottom: 1.5rem;">Select the capabilities for this role.</p>

        <div class="permissions-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 1.5rem;">
            @foreach($permissions as $group => $perms)
            <div class="permission-group" style="background: var(--bg-tertiary); padding: 1rem; border-radius: 8px;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 0.75rem; border-bottom: 1px solid var(--border-color); padding-bottom: 0.5rem;">
                    <h4 style="margin: 0; text-transform: capitalize;">{{ $group }}</h4>
                    <label style="font-size: 0.8rem; cursor: pointer;">
                        <input type="checkbox" onchange="toggleGroup(this)"> Select All
                    </label>
                </div>
                <div style="display: flex; flex-direction: column; gap: 0.5rem;">
                    @foreach($perms as $perm)
                    <label class="checkbox-wrapper" style="display: flex; align-items: center; gap: 0.5rem; font-size: 0.9rem; cursor: pointer;">
                        <input type="checkbox" name="permissions[]" value="{{ $perm->name }}">
                        {{ str_replace($group . '.', '', $perm->name) }}
                    </label>
                    @endforeach
                </div>
            </div>
            @endforeach
        </div>
    </div>

    <div class="form-actions" style="margin-top: 2rem;">
        <button type="submit" class="btn btn-primary">Create Role</button>
    </div>
</form>

<script>
    function toggleGroup(source) {
        let checkboxes = source.closest('.permission-group').querySelectorAll('input[name="permissions[]"]');
        for(let i=0; i < checkboxes.length; i++) {
            checkboxes[i].checked = source.checked;
        }
    }
</script>
@endsection
