@extends('layouts.app')

@section('title', 'Edit User')

@section('content')
    <div class="page-header">
        <div class="header-content">
            <h1>Edit User: {{ $user->full_name }}</h1>
            <p class="text-muted">Update user details and permissions</p>
        </div>
        <div class="header-actions">
            <a href="{{ route('users.index') }}" class="btn btn-secondary">
                <span class="icon">←</span> Back to Users
            </a>
        </div>
    </div>

    <div class="form-card">
        <form action="{{ route('users.update', $user) }}" method="POST">
            @csrf
            @method('PUT')
            
            <h3 style="margin-bottom: 1.5rem; color: var(--primary-light);">Personal Details</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>First Name <span class="error-text">*</span></label>
                    <input type="text" name="first_name" required value="{{ old('first_name', $user->first_name) }}">
                </div>
                <div class="form-group">
                    <label>Last Name <span class="error-text">*</span></label>
                    <input type="text" name="last_name" required value="{{ old('last_name', $user->last_name) }}">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>Email Address <span class="error-text">*</span></label>
                    <input type="email" name="email" required value="{{ old('email', $user->email) }}">
                </div>
                <div class="form-group">
                    <label>Organization (Optional)</label>
                    <select name="organization_id">
                        <option value="">Select Organization</option>
                        @foreach($organizations as $org)
                            <option value="{{ $org->id }}" {{ $user->organization_id == $org->id ? 'selected' : '' }}>
                                {{ $org->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <h3 style="margin-top: 2rem; margin-bottom: 1.5rem; color: var(--primary-light);">Account Security</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>Role <span class="error-text">*</span></label>
                    <select name="role" required>
                        <option value="">Select Role</option>
                        @foreach($roles as $role)
                            <option value="{{ $role->name }}" {{ $user->hasRole($role->name) ? 'selected' : '' }}>
                                {{ $role->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>New Password (Optional)</label>
                    <input type="password" name="password" placeholder="Leave blank to keep current">
                </div>
                <div class="form-group">
                    <label>Confirm New Password</label>
                    <input type="password" name="password_confirmation" placeholder="Leave blank to keep current">
                </div>
            </div>

            <div class="form-actions">
                <button type="button" class="btn btn-secondary" onclick="window.history.back()">Cancel</button>
                <button type="submit" class="btn btn-primary">Update User</button>
            </div>
        </form>
    </div>
@endsection
