@extends('layouts.app')

@section('title', 'User Management')

@section('content')
    <div class="page-header">
        <div class="header-content">
            <h1>User Management</h1>
            <p class="text-muted">Manage system access and roles</p>
        </div>
        <div class="header-actions">
            <a href="{{ route('users.create') }}" class="btn btn-primary">
                <span class="icon">+</span> Add New User
            </a>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">👥</div>
            <div class="stat-content">
                <h3>{{ $users->total() }}</h3>
                <span>Total Users</span>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon">🛡️</div>
            <div class="stat-content">
                <h3>{{ \Spatie\Permission\Models\Role::count() }}</h3>
                <span>Active Roles</span>
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon">🟢</div>
            <div class="stat-content">
                <h3>{{ $users->total() }}</h3>
                <span>Active Accounts</span>
            </div>
        </div>
    </div>

    <div class="card table-card">
        <!-- Toolbar -->
        <div class="filters-card" style="border: none; border-bottom: 1px solid var(--border-color); border-radius: 0; margin: 0;">
            <div class="filters-form">
                <div class="filter-group" style="flex: 2;">
                    <input type="text" placeholder="Search users by name or email..." class="form-control">
                </div>
                <div class="filter-group">
                    <select class="form-control">
                        <option value="">All Roles</option>
                        @foreach(\Spatie\Permission\Models\Role::all() as $role)
                            <option value="{{ $role->name }}">{{ $role->name }}</option>
                        @endforeach
                    </select>
                </div>
                <button class="btn btn-secondary">Filter</button>
            </div>
        </div>

        <div class="card-body" style="padding: 0;">
            <table class="data-table">
                <thead>
                    <tr>
                        <th style="padding-left: 2rem;">User</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Joined</th>
                        <th class="text-right">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                    <tr>
                        <td style="padding-left: 2rem;">
                            <div style="display: flex; align-items: center; gap: 1rem;">
                                <div class="avatar-circle" style="
                                    width: 40px; 
                                    height: 40px; 
                                    background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%); 
                                    color: white; 
                                    border-radius: 50%; 
                                    display: flex; 
                                    align-items: center; 
                                    justify-content: center; 
                                    font-weight: 600;
                                    font-size: 0.9rem;">
                                    {{ substr($user->first_name, 0, 1) }}{{ substr($user->last_name, 0, 1) }}
                                </div>
                                <div>
                                    <div class="member-name">{{ $user->full_name }}</div>
                                    <div class="text-muted" style="font-size: 0.85rem;">{{ $user->email }}</div>
                                </div>
                            </div>
                        </td>
                        <td>
                            @foreach($user->roles as $role)
                                <span class="badge {{ $role->name === 'Super Admin' ? 'badge-danger' : 'badge-primary' }}">
                                    {{ $role->name }}
                                </span>
                            @endforeach
                        </td>
                        <td>
                            @if($user->is_active)
                                <span class="badge badge-success">Active</span>
                            @else
                                <span class="badge badge-danger">Suspended</span>
                            @endif
                        </td>
                        <td class="text-muted">
                            {{ $user->created_at->format('M d, Y') }}
                        </td>
                        <td class="text-right">
                            <div class="action-buttons">
                                <a href="{{ route('users.edit', $user) }}" class="btn btn-sm btn-secondary" title="Edit">
                                    ✏️
                                </a>
                                
                                <form action="{{ route('users.toggle-status', $user) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-secondary" style="color: {{ $user->is_active ? 'var(--warning)' : 'var(--success)' }};" title="{{ $user->is_active ? 'Suspend' : 'Activate' }}">
                                        {{ $user->is_active ? '🚫' : '✅' }}
                                    </button>
                                </form>

                                <form action="{{ route('users.destroy', $user) }}" method="POST" style="display:inline;" data-confirm="Are you sure you want to delete this user? This action cannot be undone.">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-secondary" style="color: var(--danger);" title="Delete">
                                        🗑️
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="pagination-wrapper">
                {{ $users->links() }}
            </div>
        </div>
    </div>
@endsection
