<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\PledgeController;
use App\Http\Controllers\ContributionController;
use App\Http\Controllers\BudgetController;
use App\Http\Controllers\OrganizationController;

// Public Routes
// Public Routes
Route::get('/', function () {
    return redirect()->route('login');
});

// Guest Routes
Route::middleware('guest')->group(function () {
    Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [LoginController::class, 'login']);
});

// Protected Routes
Route::middleware('auth')->group(function () {
    Route::post('logout', [LoginController::class, 'logout'])->name('logout');
    Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Members
    Route::get('members/export', [MemberController::class, 'export'])->name('members.export');
    Route::resource('members', MemberController::class);
    
    // Finance - Accounts
    Route::resource('accounts', AccountController::class)->except(['show']);
    
    // Finance - Transactions
    Route::get('transactions/export', [TransactionController::class, 'export'])->name('transactions.export');
    Route::get('transactions/pending', [TransactionController::class, 'pending'])->name('transactions.pending');
    Route::post('transactions/{transaction}/approve', [TransactionController::class, 'approve'])->name('transactions.approve');
    Route::post('transactions/{transaction}/reject', [TransactionController::class, 'reject'])->name('transactions.reject');
    Route::resource('transactions', TransactionController::class)->except(['edit', 'update']);
    
    // Payments - Pledges
    Route::resource('pledges', PledgeController::class);
    
    // Payments - Contributions
    Route::resource('contributions', ContributionController::class)->except(['edit', 'update', 'destroy']);
    
    // Budgeting
    Route::post('budgets/{budget}/submit', [BudgetController::class, 'submit'])->name('budgets.submit');
    Route::post('budgets/{budget}/approve', [BudgetController::class, 'approve'])->name('budgets.approve');
    Route::post('budgets/{budget}/reject', [BudgetController::class, 'reject'])->name('budgets.reject');
    Route::post('budgets/{budget}/request-amendment', [BudgetController::class, 'requestAmendment'])->name('budgets.request-amendment');
    Route::post('budgets/{budget}/grant-amendment', [BudgetController::class, 'grantAmendment'])->name('budgets.grant-amendment');
    Route::post('budgets/{budget}/items', [BudgetController::class, 'addItem'])->name('budgets.items.store');
    Route::delete('budgets/{budget}/items/{item}', [BudgetController::class, 'removeItem'])->name('budgets.items.destroy');
    Route::resource('budgets', BudgetController::class)->except(['edit', 'update']);
    
    // Organizations
    Route::post('organizations/{organization}/leaders', [OrganizationController::class, 'addLeader'])->name('organizations.leaders.store');
    Route::delete('organizations/{organization}/leaders/{leader}', [OrganizationController::class, 'removeLeader'])->name('organizations.leaders.destroy');
    Route::get('organizations/{organization}/children', [OrganizationController::class, 'children'])->name('organizations.children');
    Route::resource('organizations', OrganizationController::class);

    // Reports
    Route::get('reports', [\App\Http\Controllers\ReportController::class, 'index'])->name('reports.index');
    Route::get('reports/export', [\App\Http\Controllers\ReportController::class, 'export'])->name('reports.export');

    // Settings
    Route::get('settings', [\App\Http\Controllers\SettingsController::class, 'index'])->name('settings.index');
    Route::post('settings', [\App\Http\Controllers\SettingsController::class, 'update'])->name('settings.update');
    Route::resource('roles', \App\Http\Controllers\RoleController::class);

    // Users
    Route::post('users/{user}/toggle-status', [\App\Http\Controllers\UserController::class, 'toggleStatus'])->name('users.toggle-status');
    Route::resource('users', \App\Http\Controllers\UserController::class);
});




