

<?php $__env->startSection('title', 'Transaction Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Transaction Details</h1>
        <p class="text-muted">Recorded on <?php echo e($transaction->created_at->format('d M Y, H:i')); ?></p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-secondary">Back to List</a>
    </div>
</div>

<div class="profile-grid">
    <div class="profile-card">
        <div class="profile-header" style="background: <?php echo e($transaction->type == 'Credit' ? 'linear-gradient(135deg, #059669 0%, #10b981 100%)' : 'linear-gradient(135deg, #dc2626 0%, #ef4444 100%)'); ?>;">
            <div class="profile-avatar">
                <?php echo e($transaction->type == 'Credit' ? '💰' : '💸'); ?>

            </div>
            <div class="profile-title">
                <h2><?php echo e($transaction->type == 'Credit' ? 'Income' : 'Expense'); ?></h2>
                <span style="color: white; font-size: 1.5rem; font-weight: 700;">
                    <?php echo e(number_format($transaction->amount, 2)); ?> <?php echo e($transaction->account?->currency); ?>

                </span>
            </div>
        </div>
        
        <div class="profile-details">
            <div class="detail-row">
                <span class="label">Date</span>
                <span class="value"><?php echo e($transaction->date->format('d M Y')); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Account</span>
                <span class="value"><?php echo e($transaction->account?->name); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Category</span>
                <span class="value"><?php echo e($transaction->category?->name); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Reference</span>
                <span class="value"><?php echo e($transaction->reference ?? '-'); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Organization</span>
                <span class="value"><?php echo e($transaction->organization?->name); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Recorded By</span>
                <span class="value"><?php echo e($transaction->recorder?->full_name ?? 'Unknown'); ?></span>
            </div>
            <?php if($transaction->description): ?>
            <div class="detail-row" style="flex-direction: column; align-items: flex-start; gap: 0.5rem;">
                <span class="label">Description</span>
                <span class="value"><?php echo e($transaction->description); ?></span>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/finance/transactions/show.blade.php ENDPATH**/ ?>