

<?php $__env->startSection('title', 'Add Account'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h1>Add New Account</h1>
    <p class="text-muted">Create a new financial account</p>
</div>

<div class="form-card">
    <form action="<?php echo e(route('accounts.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        
        <div class="form-group">
            <label for="name">Account Name *</label>
            <input type="text" id="name" name="name" value="<?php echo e(old('name')); ?>" required placeholder="e.g., CRDB Bank Account">
            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="type">Account Type *</label>
                <select id="type" name="type" required>
                    <option value="Bank" <?php echo e(old('type') == 'Bank' ? 'selected' : ''); ?>>Bank</option>
                    <option value="Mobile" <?php echo e(old('type') == 'Mobile' ? 'selected' : ''); ?>>Mobile Money</option>
                    <option value="Cash" <?php echo e(old('type') == 'Cash' ? 'selected' : ''); ?>>Cash</option>
                </select>
            </div>
            <div class="form-group">
                <label for="currency">Currency *</label>
                <input type="text" id="currency" name="currency" value="<?php echo e(old('currency', 'TZS')); ?>" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="organization_id">Organization *</label>
            <select id="organization_id" name="organization_id" required>
                <option value="">Select Organization...</option>
                <?php $__currentLoopData = $organizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($org->id); ?>" <?php echo e(old('organization_id') == $org->id ? 'selected' : ''); ?>><?php echo e($org->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php $__errorArgs = ['organization_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <div class="form-actions">
            <a href="<?php echo e(route('accounts.index')); ?>" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Create Account</button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/finance/accounts/create.blade.php ENDPATH**/ ?>