

<?php $__env->startSection('title', 'Organizations'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Organizations</h1>
        <p class="text-muted">Manage organizational hierarchy</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('organizations.create')); ?>" class="btn btn-primary">+ Add Organization</a>
    </div>
</div>

<!-- Level Legend -->
<div class="stats-grid" style="margin-bottom: 2rem;">
    <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="stat-card" style="padding: 0.75rem 1rem; text-align: center;">
        <span class="badge badge-<?php echo e($level->slug); ?>">
            <?php echo e($level->name); ?>

        </span>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<!-- Organization Tree -->
<div class="table-card">
    <?php $__currentLoopData = $organizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $__env->make('organizations.partials.tree-node', ['org' => $org, 'depth' => 0], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    <?php if($organizations->isEmpty()): ?>
        <div class="empty-state" style="padding: 2rem; text-align: center;">
            No organizations found. <a href="<?php echo e(route('organizations.create')); ?>">Create one</a>.
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/organizations/index.blade.php ENDPATH**/ ?>