



<div class="cascading-select-group" id="orgSelector">
    <div class="cascading-select-row">
        <div class="form-group">
            <label for="org_union">Union</label>
            <select id="org_union" name="org_union" onchange="loadChildren(this, 'org_conference', 'conference')">
                <option value="">Select Union...</option>
                <?php $__currentLoopData = \App\Models\Organization::whereHas('level', fn($q) => $q->where('slug', 'union'))->orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $union): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($union->id); ?>" <?php echo e(old('org_union', request('org_union')) == $union->id ? 'selected' : ''); ?>><?php echo e($union->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="form-group">
            <label for="org_conference">Conference</label>
            <select id="org_conference" name="org_conference" onchange="loadChildren(this, 'org_zone', 'zone')" disabled>
                <option value="">Select Conference...</option>
            </select>
        </div>
    </div>
    <div class="cascading-select-row">
        <div class="form-group">
            <label for="org_zone">Zone</label>
            <select id="org_zone" name="org_zone" onchange="loadChildren(this, 'organization_id', 'local')" disabled>
                <option value="">Select Zone...</option>
            </select>
        </div>
        <div class="form-group">
            <label for="organization_id">Local Church *</label>
            <select id="organization_id" name="organization_id" disabled required>
                <option value="">Select Local Church...</option>
            </select>
            <?php $__errorArgs = ['organization_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
async function loadChildren(selectElement, targetId, levelSlug) {
    const parentId = selectElement.value;
    const targetSelect = document.getElementById(targetId);
    
    // Reset all downstream selects
    resetDownstream(targetId);
    
    if (!parentId) {
        targetSelect.disabled = true;
        return;
    }
    
    try {
        const response = await fetch(`/organizations/${parentId}/children`);
        const children = await response.json();
        
        targetSelect.innerHTML = '<option value="">Select...</option>';
        children.forEach(child => {
            const option = document.createElement('option');
            option.value = child.id;
            option.textContent = child.name;
            targetSelect.appendChild(option);
        });
        
        targetSelect.disabled = false;
    } catch (error) {
        console.error('Failed to load organizations:', error);
    }
}

function resetDownstream(startId) {
    const selects = ['org_conference', 'org_zone', 'organization_id'];
    let reset = false;
    
    selects.forEach(id => {
        if (id === startId || reset) {
            reset = true;
            const select = document.getElementById(id);
            if (select) {
                select.innerHTML = '<option value="">Select...</option>';
                select.disabled = true;
            }
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/partials/org-selector.blade.php ENDPATH**/ ?>