

<?php $__env->startSection('title', 'Edit Organization'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h1>Edit Organization</h1>
    <p class="text-muted"><?php echo e($organization->name); ?></p>
</div>

<div class="form-card">
    <form action="<?php echo e(route('organizations.update', $organization)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div class="form-group">
            <label for="name">Organization Name *</label>
            <input type="text" id="name" name="name" value="<?php echo e(old('name', $organization->name)); ?>" required>
            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><span class="error-text"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="level_id">Level *</label>
                <select id="level_id" name="level_id" required>
                    <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($level->id); ?>" <?php echo e(old('level_id', $organization->level_id) == $level->id ? 'selected' : ''); ?>><?php echo e($level->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group">
                <label for="parent_id">Parent Organization</label>
                <select id="parent_id" name="parent_id">
                    <option value="">None (Top Level)</option>
                    <?php $__currentLoopData = $parentOrgs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($org->id); ?>" <?php echo e(old('parent_id', $organization->parent_id) == $org->id ? 'selected' : ''); ?>>
                        <?php echo e($org->name); ?> (<?php echo e($org->level?->name); ?>)
                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        
        <div class="form-row">
            <div class="form-group">
                <label for="code">Organization Code</label>
                <input type="text" id="code" name="code" value="<?php echo e(old('code', $organization->code)); ?>">
            </div>
            <div class="form-group">
                <label for="location">Location</label>
                <input type="text" id="location" name="location" value="<?php echo e(old('location', $organization->location)); ?>">
            </div>
        </div>
        
        <div class="form-actions">
            <a href="<?php echo e(route('organizations.show', $organization)); ?>" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Save Changes</button>
        </div>
    </form>
</div>

<!-- Danger Zone -->
<div class="form-card" style="margin-top: 2rem; border-color: var(--danger);">
    <h3 style="color: var(--danger);">⚠️ Danger Zone</h3>
    <p class="text-muted">Delete this organization. This cannot be undone.</p>
    <form action="<?php echo e(route('organizations.destroy', $organization)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <button type="submit" class="btn btn-secondary" style="background: var(--danger);" onclick="return confirm('Are you sure? This cannot be undone.')">
            Delete Organization
        </button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/organizations/edit.blade.php ENDPATH**/ ?>