

<?php $__env->startSection('title', 'Create User'); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <div class="header-content">
            <h1>Create New User</h1>
            <p class="text-muted">Add a new user to the system</p>
        </div>
        <div class="header-actions">
            <a href="<?php echo e(route('users.index')); ?>" class="btn btn-secondary">
                <span class="icon">←</span> Back to Users
            </a>
        </div>
    </div>

    <div class="form-card">
        <form action="<?php echo e(route('users.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            
            <h3 style="margin-bottom: 1.5rem; color: var(--primary-light);">Personal Details</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>First Name <span class="error-text">*</span></label>
                    <input type="text" name="first_name" required value="<?php echo e(old('first_name')); ?>">
                </div>
                <div class="form-group">
                    <label>Last Name <span class="error-text">*</span></label>
                    <input type="text" name="last_name" required value="<?php echo e(old('last_name')); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>Email Address <span class="error-text">*</span></label>
                    <input type="email" name="email" required value="<?php echo e(old('email')); ?>">
                </div>
                <div class="form-group">
                    <label>Organization (Optional)</label>
                    <select name="organization_id">
                        <option value="">Select Organization</option>
                        <?php $__currentLoopData = $organizations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($org->id); ?>"><?php echo e($org->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <h3 style="margin-top: 2rem; margin-bottom: 1.5rem; color: var(--primary-light);">Account Security</h3>
            <div class="form-row">
                <div class="form-group">
                    <label>Role <span class="error-text">*</span></label>
                    <select name="role" required>
                        <option value="">Select Role</option>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($role->name); ?>"><?php echo e($role->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>Password <span class="error-text">*</span></label>
                    <input type="password" name="password" required>
                </div>
                <div class="form-group">
                    <label>Confirm Password <span class="error-text">*</span></label>
                    <input type="password" name="password_confirmation" required>
                </div>
            </div>

            <div class="form-actions">
                <button type="button" class="btn btn-secondary" onclick="window.history.back()">Cancel</button>
                <button type="submit" class="btn btn-primary">Create User</button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/users/create.blade.php ENDPATH**/ ?>