

<?php $__env->startSection('title', 'Pending Approvals'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Pending Approvals</h1>
        <p class="text-muted">Expense transactions awaiting approval</p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('transactions.index')); ?>" class="btn btn-secondary">All Transactions</a>
    </div>
</div>

<div class="table-card">
    <table class="data-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Account</th>
                <th>Category</th>
                <th>Amount</th>
                <th>Reference</th>
                <th>Recorded By</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($transaction->date->format('d M Y')); ?></td>
                <td><?php echo e($transaction->account?->name); ?></td>
                <td><?php echo e($transaction->category?->name); ?></td>
                <td class="text-danger"><?php echo e(number_format($transaction->amount, 2)); ?></td>
                <td><?php echo e($transaction->reference ?? '-'); ?></td>
                <td><?php echo e($transaction->recorder?->full_name); ?></td>
                <td>
                    <div class="action-buttons" style="gap: 0.5rem;">
                        <?php if(auth()->user()->id !== $transaction->recorded_by && auth()->user()->can('finance.approve')): ?>
                        <form action="<?php echo e(route('transactions.approve', $transaction)); ?>" method="POST" style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-sm btn-primary" onclick="return confirm('Approve this expense?')">✅ Approve</button>
                        </form>
                        
                        <button type="button" class="btn btn-sm btn-secondary" onclick="showRejectModal(<?php echo e($transaction->id); ?>)">❌ Reject</button>
                        <?php else: ?>
                        <span class="text-muted">Own transaction</span>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="7" class="empty-state">No pending transactions.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <div class="pagination-wrapper">
        <?php echo e($transactions->links()); ?>

    </div>
</div>

<!-- Reject Modal -->
<div id="rejectModal" class="modal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:1000; justify-content:center; align-items:center;">
    <div class="form-card" style="max-width:500px; margin:2rem;">
        <h3 style="margin-bottom:1rem;">Reject Transaction</h3>
        <form id="rejectForm" method="POST">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="rejection_reason">Reason for Rejection *</label>
                <textarea id="rejection_reason" name="rejection_reason" rows="3" required placeholder="Explain why this transaction is being rejected..."></textarea>
            </div>
            <div class="form-actions">
                <button type="button" class="btn btn-secondary" onclick="hideRejectModal()">Cancel</button>
                <button type="submit" class="btn btn-primary" style="background: var(--danger);">Reject</button>
            </div>
        </form>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function showRejectModal(id) {
    document.getElementById('rejectForm').action = '/transactions/' + id + '/reject';
    document.getElementById('rejectModal').style.display = 'flex';
}
function hideRejectModal() {
    document.getElementById('rejectModal').style.display = 'none';
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/finance/transactions/pending.blade.php ENDPATH**/ ?>