

<?php $__env->startSection('title', 'Pledge Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1>Pledge Details</h1>
        <p class="text-muted"><?php echo e($pledge->purpose); ?> - <?php echo e($pledge->year); ?></p>
    </div>
    <div class="header-actions">
        <a href="<?php echo e(route('contributions.create', ['member_id' => $pledge->member_id, 'pledge_id' => $pledge->id])); ?>" class="btn btn-primary">+ Make Payment</a>
        <a href="<?php echo e(route('pledges.edit', $pledge)); ?>" class="btn btn-secondary">Edit</a>
    </div>
</div>

<div class="profile-grid">
    <div class="profile-card">
        <div class="profile-header">
            <div class="profile-avatar">📋</div>
            <div class="profile-title">
                <h2><?php echo e($pledge->member?->full_name); ?></h2>
                <span style="color: white;"><?php echo e($pledge->member?->organization?->name); ?></span>
            </div>
        </div>
        
        <div class="profile-details">
            <div class="detail-row">
                <span class="label">Year</span>
                <span class="value"><?php echo e($pledge->year); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Purpose</span>
                <span class="value"><?php echo e($pledge->purpose); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Pledged Amount</span>
                <span class="value">TZS <?php echo e(number_format($pledge->amount, 2)); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Paid Amount</span>
                <span class="value text-success">TZS <?php echo e(number_format($pledge->paid_amount, 2)); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Remaining</span>
                <span class="value text-danger">TZS <?php echo e(number_format($pledge->remaining, 2)); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Progress</span>
                <span class="value"><?php echo e($pledge->progress); ?>%</span>
            </div>
            <div class="detail-row">
                <span class="label">Status</span>
                <span class="value">
                    <?php if($pledge->status === 'Pending'): ?>
                        <span class="badge badge-warning">Pending</span>
                    <?php elseif($pledge->status === 'Partial'): ?>
                        <span class="badge badge-info">Partial</span>
                    <?php else: ?>
                        <span class="badge badge-success">Completed</span>
                    <?php endif; ?>
                </span>
            </div>
        </div>
    </div>
    
    <div class="sidebar-card">
        <h3>Payment History</h3>
        <?php $__empty_1 = true; $__currentLoopData = $pledge->contributions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contribution): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="stat-item">
            <span class="stat-label"><?php echo e($contribution->date->format('d M Y')); ?></span>
            <span class="stat-value text-success">+<?php echo e(number_format($contribution->amount, 2)); ?></span>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p class="text-muted">No payments yet.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/payments/pledges/show.blade.php ENDPATH**/ ?>