

<?php $__env->startSection('title', $member->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="header-left">
        <h1><?php echo e($member->full_name); ?></h1>
        <p class="text-muted">Member Profile</p>
    </div>
    <div class="header-actions">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('members.edit')): ?>
        <a href="<?php echo e(route('members.edit', $member)); ?>" class="btn btn-primary">Edit</a>
        <?php endif; ?>
        <a href="<?php echo e(route('members.index')); ?>" class="btn btn-secondary">Back to List</a>
    </div>
</div>

<div class="profile-grid">
    <div class="profile-card">
        <div class="profile-header">
            <div class="profile-avatar">
                <?php echo e(strtoupper(substr($member->first_name, 0, 1) . substr($member->last_name, 0, 1))); ?>

            </div>
            <div class="profile-title">
                <h2><?php echo e($member->full_name); ?></h2>
                <span class="badge badge-<?php echo e($member->status == 'Active' ? 'success' : 'warning'); ?>"><?php echo e($member->status); ?></span>
            </div>
        </div>
        
        <div class="profile-details">
            <div class="detail-row">
                <span class="label">Organization</span>
                <span class="value"><?php echo e($member->organization?->name ?? '-'); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Category</span>
                <span class="value"><?php echo e($member->category); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Phone</span>
                <span class="value"><?php echo e($member->phone ?? '-'); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Email</span>
                <span class="value"><?php echo e($member->email ?? '-'); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Date of Birth</span>
                <span class="value"><?php echo e($member->dob?->format('d M Y') ?? '-'); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Gender</span>
                <span class="value"><?php echo e($member->gender ?? '-'); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Marital Status</span>
                <span class="value"><?php echo e($member->marital_status ?? '-'); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Profession</span>
                <span class="value"><?php echo e($member->profession ?? '-'); ?></span>
            </div>
            <div class="detail-row">
                <span class="label">Registered</span>
                <span class="value"><?php echo e($member->created_at->format('d M Y')); ?></span>
            </div>
        </div>
    </div>
    
    <div class="profile-sidebar">
        <div class="sidebar-card">
            <h3>Quick Stats</h3>
            <div class="stat-item">
                <span class="stat-label">Contributions</span>
                <span class="stat-value">0</span>
            </div>
            <div class="stat-item">
                <span class="stat-label">Pledges</span>
                <span class="stat-value">0</span>
            </div>
            <div class="stat-item">
                <span class="stat-label">Events Attended</span>
                <span class="stat-value">0</span>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Projects\Atape\AtapeMgr\resources\views/members/show.blade.php ENDPATH**/ ?>